/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SerializableStoresNonSerializableInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("serializable.stores.non.serializable.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiElement classOrLambda = (PsiElement)infos[0];
        PsiType type = (PsiType)infos[1];
        if (classOrLambda instanceof PsiClass) {
            PsiClass aClass = (PsiClass)classOrLambda;
            if (aClass instanceof PsiAnonymousClass) {
                return InspectionGadgetsBundle.message("serializable.anonymous.class.stores.non.serializable.problem.descriptor", type.getPresentableText());
            }
            return InspectionGadgetsBundle.message("serializable.local.class.stores.non.serializable.problem.descriptor", type.getPresentableText(), aClass.getName());
        }
        return InspectionGadgetsBundle.message("serializable.lambda.stores.non.serializable.problem.descriptor", type.getPresentableText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableStoresNonSerializableVisitor();
    }

    private static class SerializableStoresNonSerializableVisitor
    extends BaseInspectionVisitor {
        private SerializableStoresNonSerializableVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiDeclarationStatement) && !(aClass instanceof PsiAnonymousClass)) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            LocalVariableReferenceFinder visitor = new LocalVariableReferenceFinder((PsiElement)aClass);
            aClass.accept((PsiElementVisitor)visitor);
        }

        public void visitLambdaExpression(PsiLambdaExpression lambda2) {
            super.visitLambdaExpression(lambda2);
            PsiType type = lambda2.getFunctionalInterfaceType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            LocalVariableReferenceFinder visitor = new LocalVariableReferenceFinder((PsiElement)lambda2);
            lambda2.accept((PsiElementVisitor)visitor);
        }

        private class LocalVariableReferenceFinder
        extends JavaRecursiveElementWalkingVisitor {
            @NotNull
            private final PsiElement myClassOrLambda;

            public LocalVariableReferenceFinder(PsiElement classOrLambda) {
                this.myClassOrLambda = classOrLambda;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                if (expression.getQualifierExpression() != null) {
                    return;
                }
                PsiType type = expression.getType();
                if (SerializationUtils.isProbablySerializable(type)) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (!(target instanceof PsiLocalVariable) && !(target instanceof PsiParameter)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (!(variable.hasModifierProperty("final") || PsiUtil.isLanguageLevel8OrHigher((PsiElement)variable) && HighlightControlFlowUtil.isEffectivelyFinal(variable, this.myClassOrLambda, (PsiJavaCodeReferenceElement)expression))) {
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)this.myClassOrLambda, (PsiElement)variable, (boolean)true)) {
                    return;
                }
                SerializableStoresNonSerializableVisitor.this.registerError((PsiElement)expression, new Object[]{this.myClassOrLambda, type});
            }
        }
    }
}

