/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableWithSerialVersionUIDFieldInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonSerializableClassWithSerialVersionUID";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("non.serializable.with.serialversionuid.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass.isAnnotationType()) {
            return InspectionGadgetsBundle.message("non.serializable.@interface.with.serialversionuid.problem.descriptor", new Object[0]);
        }
        if (aClass.isInterface()) {
            return InspectionGadgetsBundle.message("non.serializable.interface.with.serialversionuid.problem.descriptor", new Object[0]);
        }
        if (aClass instanceof PsiAnonymousClass) {
            return InspectionGadgetsBundle.message("non.serializable.anonymous.with.serialversionuid.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("non.serializable.class.with.serialversionuid.problem.descriptor", new Object[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass.isAnnotationType() || aClass.isInterface() || aClass instanceof PsiAnonymousClass) {
            return new InspectionGadgetsFix[]{new RemoveSerialVersionUIDFix()};
        }
        return new InspectionGadgetsFix[]{DelegatingFixFactory.createMakeSerializableFix(aClass), new RemoveSerialVersionUIDFix()};
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableWithSerialVersionUIDVisitor();
    }

    private static class NonSerializableWithSerialVersionUIDVisitor
    extends BaseInspectionVisitor {
        private NonSerializableWithSerialVersionUIDVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField field = aClass.findFieldByName("serialVersionUID", false);
            if (field == null) {
                return;
            }
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }

    private static class RemoveSerialVersionUIDFix
    extends InspectionGadgetsFix {
        private RemoveSerialVersionUIDFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("non.serializable.with.serialversionuid.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement nameElement = descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)nameElement.getParent();
            PsiField field = aClass.findFieldByName("serialVersionUID", false);
            if (field == null) {
                return;
            }
            field.delete();
        }
    }
}

