/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalizableWithoutPublicNoArgConstructorInspectionBase
extends BaseInspection {
    @Nullable
    protected static PsiMethod getNoArgConstructor(PsiClass aClass) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            PsiParameterList parameterList = constructor.getParameterList();
            if (parameterList.getParametersCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("externalizable.without.public.no.arg.constructor.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("externalizable.without.public.no.arg.constructor.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExternalizableWithoutPublicNoArgConstructorVisitor();
    }

    private static class ExternalizableWithoutPublicNoArgConstructorVisitor
    extends BaseInspectionVisitor {
        private ExternalizableWithoutPublicNoArgConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType() || aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!ExternalizableWithoutPublicNoArgConstructorVisitor.isExternalizable(aClass)) {
                return;
            }
            PsiMethod constructor = ExternalizableWithoutPublicNoArgConstructorInspectionBase.getNoArgConstructor(aClass);
            if (constructor == null ? aClass.hasModifierProperty("public") : constructor.hasModifierProperty("public")) {
                return;
            }
            if (SerializationUtils.hasWriteReplace(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass, constructor);
        }

        private static boolean isExternalizable(PsiClass aClass) {
            PsiClass externalizableClass = ClassUtils.findClass("java.io.Externalizable", (PsiElement)aClass);
            return externalizableClass != null && aClass.isInheritor(externalizableClass, true);
        }
    }
}

