/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class PublicStaticArrayFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("public.static.array.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("public.static.array.field.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicStaticArrayFieldVisitor();
    }

    private static class PublicStaticArrayFieldVisitor
    extends BaseInspectionVisitor {
        private PublicStaticArrayFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("public")) {
                return;
            }
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiType type = field.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            if (CollectionUtils.isConstantEmptyArray(field)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

