/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadLibraryWithNonConstantStringInspection
extends BaseInspection {
    public boolean considerStaticFinalConstant = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("load.library.with.non.constant.string.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String qualifier = (String)infos[0];
        return InspectionGadgetsBundle.message("load.library.with.non.constant.string.problem.descriptor", qualifier);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("consider.static.final.fields.constant.option", new Object[0]), (InspectionProfileEntry)this, "considerStaticFinalConstant");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RuntimeExecVisitor();
    }

    private class RuntimeExecVisitor
    extends BaseInspectionVisitor {
        private RuntimeExecVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (MethodCallUtils.callWithNonConstantString(expression, LoadLibraryWithNonConstantStringInspection.this.considerStaticFinalConstant, "java.lang.System", "load", "loadLibrary")) {
                this.registerMethodCallError(expression, "System");
            } else if (MethodCallUtils.callWithNonConstantString(expression, LoadLibraryWithNonConstantStringInspection.this.considerStaticFinalConstant, "java.lang.Runtime", "load", "loadLibrary")) {
                this.registerMethodCallError(expression, "Runtime");
            }
        }
    }
}

