/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class CloneableClassInSecureContextInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("cloneable.class.in.secure.context.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("cloneable.class.in.secure.context.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneableClassInSecureContextVisitor();
    }

    private static class CloneableClassInSecureContextVisitor
    extends BaseInspectionVisitor {
        private CloneableClassInSecureContextVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!CloneUtils.isCloneable(aClass)) {
                return;
            }
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!CloneUtils.isClone(method) || !ControlFlowUtils.methodAlwaysThrowsException(method)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

