/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class IOResourceInspectionBase
extends ResourceInspection {
    protected static final String[] IO_TYPES = new String[]{"java.io.InputStream", "java.io.OutputStream", "java.io.Reader", "java.io.Writer", "java.io.RandomAccessFile", "java.util.zip.ZipFile", "java.io.Closeable"};
    final List<String> ignoredTypes = new ArrayList<String>();
    public String ignoredTypesString = "java.io.ByteArrayOutputStream,java.io.ByteArrayInputStream,java.io.StringBufferInputStream,java.io.CharArrayWriter,java.io.CharArrayReader,java.io.StringWriter,java.io.StringReader";

    public IOResourceInspectionBase() {
        IOResourceInspectionBase.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    @NotNull
    public String getID() {
        return "IOResourceOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("i.o.resource.opened.not.closed.display.name", new Object[0]);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        IOResourceInspectionBase.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.ignoredTypesString = IOResourceInspectionBase.formatString(this.ignoredTypes);
        super.writeSettings(element);
    }

    @Override
    public boolean isResourceCreation(PsiExpression expression) {
        if (expression instanceof PsiNewExpression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression, IO_TYPES) != null && !this.isIgnoredType(expression);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getResourceAsStream".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Class", "java.lang.ClassLoader") == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(expression, "java.io.InputStream");
        }
        return false;
    }

    private boolean isIgnoredType(PsiExpression expression) {
        return TypeUtils.expressionHasTypeOrSubtype(expression, this.ignoredTypes);
    }
}

