/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class UnusedLabelInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unused.label.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedLabelVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unused.label.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnusedLabelFix();
    }

    private static class LabelFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean found;
        private final String label;

        private LabelFinder(PsiLabeledStatement target) {
            PsiIdentifier labelIdentifier = target.getLabelIdentifier();
            this.label = labelIdentifier.getText();
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement continueStatement) {
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (this.labelMatches(labelIdentifier)) {
                this.found = true;
            }
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement breakStatement) {
            if (this.found) {
                return;
            }
            super.visitBreakStatement(breakStatement);
            PsiIdentifier labelIdentifier = breakStatement.getLabelIdentifier();
            if (this.labelMatches(labelIdentifier)) {
                this.found = true;
            }
        }

        private boolean labelMatches(PsiIdentifier labelIdentifier) {
            if (labelIdentifier == null) {
                return false;
            }
            String labelText = labelIdentifier.getText();
            return labelText.equals(this.label);
        }

        boolean jumpFound() {
            return this.found;
        }
    }

    private static class UnusedLabelVisitor
    extends BaseInspectionVisitor {
        private UnusedLabelVisitor() {
        }

        public void visitLabeledStatement(PsiLabeledStatement statement2) {
            if (UnusedLabelVisitor.containsBreakOrContinueForLabel(statement2)) {
                return;
            }
            PsiIdentifier labelIdentifier = statement2.getLabelIdentifier();
            this.registerError((PsiElement)labelIdentifier, new Object[0]);
        }

        private static boolean containsBreakOrContinueForLabel(PsiLabeledStatement statement2) {
            LabelFinder labelFinder = new LabelFinder(statement2);
            statement2.accept((PsiElementVisitor)labelFinder);
            return labelFinder.jumpFound();
        }
    }

    private static class UnusedLabelFix
    extends InspectionGadgetsFix {
        private UnusedLabelFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("unused.label.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement label = descriptor.getPsiElement();
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)label.getParent();
            assert (labeledStatement != null);
            PsiStatement statement2 = labeledStatement.getStatement();
            if (statement2 == null) {
                return;
            }
            String statementText = statement2.getText();
            PsiReplacementUtil.replaceStatement((PsiStatement)labeledStatement, statementText);
        }
    }
}

