/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class VariableUsedInInnerClassVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean usedInInnerClass;
    private int inInnerClassCount;

    VariableUsedInInnerClassVisitor(@NotNull PsiVariable variable) {
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (!this.usedInInnerClass) {
            super.visitElement(element);
        }
    }

    public void visitJavaToken(PsiJavaToken token) {
        super.visitJavaToken(token);
        PsiElement parent = token.getParent();
        if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            if (token.getTokenType() == JavaTokenType.LBRACE && aClass.getLBrace() == token) {
                ++this.inInnerClassCount;
            }
            if (token.getTokenType() == JavaTokenType.RBRACE && aClass.getRBrace() == token) {
                --this.inInnerClassCount;
            }
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
        PsiElement target;
        if (this.usedInInnerClass) {
            return;
        }
        super.visitReferenceExpression(referenceExpression);
        if (this.inInnerClassCount > 0 && this.variable.equals(target = referenceExpression.resolve())) {
            this.usedInInnerClass = true;
        }
    }

    boolean isUsedInInnerClass() {
        return this.usedInInnerClass;
    }
}

