/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableAssignedFromVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean assignedFrom = false;
    @NotNull
    private final PsiVariable variable;

    public VariableAssignedFromVisitor(@NotNull PsiVariable variable) {
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (!this.assignedFrom) {
            super.visitElement(element);
        }
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (this.assignedFrom) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression arg = assignment.getRExpression();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
        }
    }

    public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement2) {
        PsiElement[] declaredElements;
        if (this.assignedFrom) {
            return;
        }
        super.visitDeclarationStatement(statement2);
        for (PsiElement declaredElement : declaredElements = statement2.getDeclaredElements()) {
            PsiVariable declaredVariable;
            PsiExpression initializer;
            if (!(declaredElement instanceof PsiVariable) || (initializer = (declaredVariable = (PsiVariable)declaredElement).getInitializer()) == null || !VariableAccessUtils.mayEvaluateToVariable(initializer, this.variable)) continue;
            this.assignedFrom = true;
            return;
        }
    }

    public void visitVariable(@NotNull PsiVariable var) {
        if (this.assignedFrom) {
            return;
        }
        super.visitVariable(var);
        PsiExpression arg = var.getInitializer();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
        }
    }

    public boolean isAssignedFrom() {
        return this.assignedFrom;
    }
}

