/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public class SideEffectChecker {
    private static final Set<String> ourSideEffectFreeClasses = new THashSet(Arrays.asList(Object.class.getName(), Short.class.getName(), Character.class.getName(), Byte.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), String.class.getName(), StringBuffer.class.getName(), Boolean.class.getName(), ArrayList.class.getName(), Date.class.getName(), HashMap.class.getName(), HashSet.class.getName(), Hashtable.class.getName(), LinkedHashMap.class.getName(), LinkedHashSet.class.getName(), LinkedList.class.getName(), Stack.class.getName(), TreeMap.class.getName(), TreeSet.class.getName(), Vector.class.getName(), WeakHashMap.class.getName()));

    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull PsiExpression exp) {
        SideEffectsVisitor visitor = new SideEffectsVisitor();
        exp.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    public static boolean checkSideEffects(@NotNull PsiExpression element, @NotNull List<PsiElement> sideEffects) {
        SideEffectsVisitor visitor = new SideEffectsVisitor();
        element.accept((PsiElementVisitor)visitor);
        if (visitor.sideEffect != null) {
            sideEffects.add(visitor.sideEffect);
            return true;
        }
        return false;
    }

    private static boolean isSideEffectFreeConstructor(@NotNull PsiNewExpression newExpression) {
        PsiClass throwableClass;
        String packageName;
        String qualifiedName;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        PsiClass aClass = classReference == null ? null : (PsiClass)classReference.resolve();
        String string = qualifiedName = aClass == null ? null : aClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (ourSideEffectFreeClasses.contains(qualifiedName)) {
            return true;
        }
        PsiFile file2 = aClass.getContainingFile();
        PsiDirectory directory = file2.getContainingDirectory();
        PsiPackage classPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
        String string2 = packageName = classPackage == null ? null : classPackage.getQualifiedName();
        return ("java.lang".equals(packageName) || "java.io".equals(packageName)) && (throwableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope())) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)throwableClass, (boolean)true);
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        PsiElement sideEffect;

        private SideEffectsVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.sideEffect == null) {
                super.visitElement(element);
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitAssignmentExpression(expression);
            this.sideEffect = expression;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method != null && (PropertyUtil.isSimpleGetter((PsiMethod)method) || ControlFlowAnalyzer.isPure(method))) {
                return;
            }
            this.sideEffect = expression;
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitNewExpression(expression);
            this.sideEffect = SideEffectChecker.isSideEffectFreeConstructor(expression) ? null : expression;
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitPostfixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.sideEffect = expression;
            }
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitPrefixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.sideEffect = expression;
            }
        }

        public boolean mayHaveSideEffects() {
            return this.sideEffect != null;
        }
    }
}

