/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializationUtils {
    private SerializationUtils() {
    }

    public static boolean isSerializable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Serializable");
    }

    public static boolean isExternalizable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Externalizable");
    }

    public static boolean isDirectlySerializable(@NotNull PsiClass aClass) {
        PsiJavaCodeReferenceElement[] interfaces;
        PsiReferenceList implementsList = aClass.getImplementsList();
        if (implementsList == null) {
            return false;
        }
        for (PsiJavaCodeReferenceElement aInterfaces : interfaces = implementsList.getReferenceElements()) {
            String name;
            PsiClass implemented = (PsiClass)aInterfaces.resolve();
            if (implemented == null || !"java.io.Serializable".equals(name = implemented.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadObject(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.findMethodsByName("readObject", false)) {
            if (!SerializationUtils.isReadObject(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadResolve(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.findMethodsByName("readResolve", true)) {
            if (!SerializationUtils.isReadResolve(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWriteObject(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.findMethodsByName("writeObject", false)) {
            if (!SerializationUtils.isWriteObject(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWriteReplace(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.findMethodsByName("writeReplace", true)) {
            if (!SerializationUtils.isWriteReplace(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadObject(@NotNull PsiMethod method) {
        PsiClassType type = TypeUtils.getType("java.io.ObjectInputStream", (PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiType.VOID, "readObject", new PsiType[]{type});
    }

    public static boolean isWriteObject(@NotNull PsiMethod method) {
        PsiClassType type = TypeUtils.getType("java.io.ObjectOutputStream", (PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiType.VOID, "writeObject", new PsiType[]{type});
    }

    public static boolean isReadResolve(@NotNull PsiMethod method) {
        return MethodUtils.simpleMethodMatches(method, null, "java.lang.Object", "readResolve", new String[0]);
    }

    public static boolean isWriteReplace(@NotNull PsiMethod method) {
        return MethodUtils.simpleMethodMatches(method, null, "java.lang.Object", "writeReplace", new String[0]);
    }

    public static boolean isProbablySerializable(PsiType type) {
        if (type instanceof PsiWildcardType) {
            return true;
        }
        if (type instanceof PsiPrimitiveType) {
            return true;
        }
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType componentType = arrayType.getComponentType();
            return SerializationUtils.isProbablySerializable(componentType);
        }
        if (type instanceof PsiClassType) {
            PsiClassType classTYpe = (PsiClassType)type;
            PsiClass psiClass = classTYpe.resolve();
            if (SerializationUtils.isSerializable(psiClass)) {
                return true;
            }
            if (SerializationUtils.isExternalizable(psiClass)) {
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Map")) {
                PsiType[] parameters;
                for (PsiType parameter : parameters = classTYpe.getParameters()) {
                    if (SerializationUtils.isProbablySerializable(parameter)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

