/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodUtils {
    private MethodUtils() {
    }

    public static boolean isCompareTo(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        return MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "compareTo", new PsiType[]{PsiType.NULL});
    }

    public static boolean isHashCode(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        return MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "hashCode", new PsiType[0]);
    }

    public static boolean isToString(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)stringType, "toString", new PsiType[0]);
    }

    public static boolean isEquals(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType objectType = TypeUtils.getObjectType((PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiType.BOOLEAN, "equals", new PsiType[]{objectType});
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        String name;
        Matcher matcher;
        if (methodNamePattern != null && !(matcher = methodNamePattern.matcher(name = method.getName())).matches()) {
            return false;
        }
        return MethodUtils.methodMatches(method, containingClassName, returnType, parameterTypes);
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        String name = method.getName();
        if (methodName != null && !methodName.equals(name)) {
            return false;
        }
        return MethodUtils.methodMatches(method, containingClassName, returnType, parameterTypes);
    }

    private static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, PsiType ... parameterTypes) {
        PsiType methodReturnType;
        if (parameterTypes != null) {
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != parameterTypes.length) {
                return false;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiType type = parameter.getType();
                PsiType parameterType = parameterTypes[i];
                if (PsiType.NULL.equals((Object)parameterType) || parameterType == null || EquivalenceChecker.typesAreEquivalent(type, parameterType)) continue;
                return false;
            }
        }
        if (returnType != null && !EquivalenceChecker.typesAreEquivalent(returnType, methodReturnType = method.getReturnType())) {
            return false;
        }
        if (containingClassName != null) {
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)containingClassName);
        }
        return true;
    }

    public static boolean simpleMethodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @NonNls @Nullable String returnTypeString, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        Project project2 = method.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        try {
            if (parameterTypeStrings != null) {
                PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
                for (int i = 0; i < parameterTypeStrings.length; ++i) {
                    String parameterTypeString = parameterTypeStrings[i];
                    parameterTypes[i] = factory.createTypeFromText(parameterTypeString, (PsiElement)method);
                }
                if (returnTypeString != null) {
                    PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                    return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, parameterTypes);
                }
                return MethodUtils.methodMatches(method, containingClassName, null, methodName, parameterTypes);
            }
            if (returnTypeString != null) {
                PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, new PsiType[0]);
            }
            return MethodUtils.methodMatches(method, containingClassName, null, methodName, new PsiType[0]);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasSuper(@NotNull PsiMethod method) {
        return MethodUtils.getSuper(method) != null;
    }

    @Nullable
    public static PsiMethod getSuper(@NotNull PsiMethod method) {
        if (method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
            return null;
        }
        MethodSignatureBackedByPsiMethod signature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
        if (signature == null) {
            return null;
        }
        return signature.getMethod();
    }

    public static boolean isOverridden(PsiMethod method) {
        if (method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
            return false;
        }
        Query overridingMethodQuery = OverridingMethodsSearch.search((PsiMethod)method);
        PsiMethod result = (PsiMethod)overridingMethodQuery.findFirst();
        return result != null;
    }

    public static boolean isOverriddenInHierarchy(PsiMethod method, PsiClass baseClass) {
        Query search = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)baseClass.getUseScope(), (boolean)true, (boolean)true, (boolean)true);
        for (PsiClass inheritor : search) {
            PsiMethod overridingMethod = inheritor.findMethodBySignature(method, false);
            if (overridingMethod == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(PsiMethod method) {
        return ControlFlowUtils.isEmptyCodeBlock(method.getBody());
    }

    public static boolean isTrivial(PsiMethod method, boolean throwIsTrivial) {
        return MethodUtils.isTrivial(method.getBody(), throwIsTrivial);
    }

    public static boolean isTrivial(PsiClassInitializer initializer) {
        return MethodUtils.isTrivial(initializer.getBody(), false);
    }

    private static boolean isTrivial(PsiCodeBlock codeBlock, boolean throwIsTrivial) {
        if (codeBlock == null) {
            return true;
        }
        PsiStatement[] statements = codeBlock.getStatements();
        if (statements.length == 0) {
            return true;
        }
        for (PsiStatement statement2 : statements) {
            if (statement2 instanceof PsiEmptyStatement) continue;
            if (statement2 instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
                PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
                if (returnValue != null && !(returnValue instanceof PsiLiteralExpression)) continue;
                return true;
            }
            if (statement2 instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement2;
                PsiExpression condition = ifStatement.getCondition();
                Object result = ExpressionUtils.computeConstantExpression(condition);
                if (result != null && result.equals(Boolean.FALSE)) continue;
                return false;
            }
            if (statement2 instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
                PsiExpression expression = expressionStatement.getExpression();
                if (!(expression instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                if ("super".equals(methodExpression.getText())) continue;
                return false;
            }
            return throwIsTrivial && statement2 instanceof PsiThrowStatement;
        }
        return true;
    }

    public static boolean hasInThrows(@NotNull PsiMethod method, String ... exceptions) {
        PsiJavaCodeReferenceElement[] references;
        if (exceptions.length == 0) {
            throw new IllegalArgumentException("no exceptions specified");
        }
        PsiReferenceList throwsList = method.getThrowsList();
        for (PsiJavaCodeReferenceElement reference : references = throwsList.getReferenceElements()) {
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)target;
            String qualifiedName = aClass.getQualifiedName();
            for (String exception : exceptions) {
                if (!exception.equals(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isChainable(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiElement navigationElement = method.getNavigationElement();
        if (!(navigationElement instanceof PsiMethod)) {
            return false;
        }
        method = (PsiMethod)navigationElement;
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method.getBody());
        if (!(lastStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)lastStatement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        return returnValue instanceof PsiThisExpression;
    }
}

