/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtils {
    private static final Set<String> s_genericExceptionTypes = new HashSet<String>(4);

    private ExceptionUtils() {
    }

    @NotNull
    public static Set<PsiType> calculateExceptionsThrown(@Nullable PsiElement element) {
        return ExceptionUtils.calculateExceptionsThrown(element, new LinkedHashSet<PsiType>(5));
    }

    @NotNull
    public static Set<PsiType> calculateExceptionsThrown(@Nullable PsiElement element, @NotNull Set<PsiType> out) {
        if (element == null) {
            return out;
        }
        if (element instanceof PsiResourceList) {
            PsiResourceList resourceList = (PsiResourceList)element;
            for (PsiResourceListElement resource : resourceList) {
                PsiMethod method = PsiUtil.getResourceCloserMethod((PsiResourceListElement)resource);
                ExceptionUtils.collectExceptionsThrown(method, out);
            }
        }
        ExceptionsThrownVisitor visitor = new ExceptionsThrownVisitor(out);
        element.accept((PsiElementVisitor)visitor);
        return out;
    }

    public static boolean isGenericExceptionClass(@Nullable PsiType exceptionType) {
        if (!(exceptionType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)exceptionType;
        String className = classType.getCanonicalText();
        return s_genericExceptionTypes.contains(className);
    }

    public static boolean isThrowableRethrown(PsiParameter throwable, PsiCodeBlock catchBlock) {
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(catchBlock);
        if (!(lastStatement instanceof PsiThrowStatement)) {
            return false;
        }
        PsiThrowStatement throwStatement = (PsiThrowStatement)lastStatement;
        PsiExpression expression = throwStatement.getException();
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement element = referenceExpression.resolve();
        return throwable.equals(element);
    }

    static boolean statementThrowsException(PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiReturnStatement || statement2 instanceof PsiExpressionStatement || statement2 instanceof PsiExpressionListStatement || statement2 instanceof PsiForeachStatement || statement2 instanceof PsiDeclarationStatement || statement2 instanceof PsiEmptyStatement || statement2 instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement2 instanceof PsiThrowStatement) {
            return true;
        }
        if (statement2 instanceof PsiForStatement) {
            return ExceptionUtils.forStatementThrowsException((PsiForStatement)statement2);
        }
        if (statement2 instanceof PsiWhileStatement) {
            return ExceptionUtils.whileStatementThrowsException((PsiWhileStatement)statement2);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            return ExceptionUtils.doWhileThrowsException((PsiDoWhileStatement)statement2);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            PsiCodeBlock body = synchronizedStatement.getBody();
            return ExceptionUtils.blockThrowsException(body);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return ExceptionUtils.blockThrowsException(codeBlock);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return ExceptionUtils.statementThrowsException(statementLabeled);
        }
        if (statement2 instanceof PsiIfStatement) {
            return ExceptionUtils.ifStatementThrowsException((PsiIfStatement)statement2);
        }
        if (statement2 instanceof PsiTryStatement) {
            return ExceptionUtils.tryStatementThrowsException((PsiTryStatement)statement2);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            return false;
        }
        return false;
    }

    static boolean blockThrowsException(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return false;
        }
        for (PsiStatement statement2 : statements = block.getStatements()) {
            if (!ExceptionUtils.statementThrowsException(statement2)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementThrowsException(PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
        if (catchBlocks.length == 0 && ExceptionUtils.blockThrowsException(tryBlock = tryStatement.getTryBlock())) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return ExceptionUtils.blockThrowsException(finallyBlock);
    }

    private static boolean ifStatementThrowsException(PsiIfStatement ifStatement) {
        return ExceptionUtils.statementThrowsException(ifStatement.getThenBranch()) && ExceptionUtils.statementThrowsException(ifStatement.getElseBranch());
    }

    private static boolean doWhileThrowsException(PsiDoWhileStatement doWhileStatement) {
        return ExceptionUtils.statementThrowsException(doWhileStatement.getBody());
    }

    private static boolean whileStatementThrowsException(PsiWhileStatement whileStatement) {
        PsiStatement body;
        PsiExpression condition = whileStatement.getCondition();
        return BoolUtils.isTrue(condition) && ExceptionUtils.statementThrowsException(body = whileStatement.getBody());
    }

    private static boolean forStatementThrowsException(PsiForStatement forStatement) {
        PsiStatement initialization = forStatement.getInitialization();
        if (ExceptionUtils.statementThrowsException(initialization)) {
            return true;
        }
        PsiExpression test = forStatement.getCondition();
        if (BoolUtils.isTrue(test)) {
            PsiStatement body = forStatement.getBody();
            if (ExceptionUtils.statementThrowsException(body)) {
                return true;
            }
            PsiStatement update = forStatement.getUpdate();
            if (ExceptionUtils.statementThrowsException(update)) {
                return true;
            }
        }
        return false;
    }

    private static void collectExceptionsThrown(@Nullable PsiMethod method, @NotNull Set<PsiType> out) {
        if (method == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        for (PsiJavaCodeReferenceElement referenceElement : method.getThrowsList().getReferenceElements()) {
            PsiClass exceptionClass = (PsiClass)referenceElement.resolve();
            if (exceptionClass == null) continue;
            out.add((PsiType)factory.createType(exceptionClass));
        }
    }

    public static Set<PsiType> getExceptionTypesHandled(PsiTryStatement statement2) {
        HashSet<PsiType> out = new HashSet<PsiType>(5);
        for (PsiParameter parameter : statement2.getCatchBlockParameters()) {
            PsiType type = parameter.getType();
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                out.addAll(disjunctionType.getDisjunctions());
                continue;
            }
            out.add(type);
        }
        return out;
    }

    static {
        s_genericExceptionTypes.add("java.lang.Throwable");
        s_genericExceptionTypes.add("java.lang.Exception");
        s_genericExceptionTypes.add("java.lang.RuntimeException");
        s_genericExceptionTypes.add("java.lang.Error");
    }

    private static class ExceptionsThrownVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiType> m_exceptionsThrown;

        private ExceptionsThrownVisitor(Set<PsiType> thrownTypes) {
            this.m_exceptionsThrown = thrownTypes;
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            ExceptionUtils.collectExceptionsThrown(callExpression.resolveMethod(), this.m_exceptionsThrown);
        }

        public void visitThrowStatement(PsiThrowStatement statement2) {
            super.visitThrowStatement(statement2);
            PsiExpression exception = statement2.getException();
            if (exception == null) {
                return;
            }
            PsiType type = exception.getType();
            if (type != null) {
                this.m_exceptionsThrown.add(type);
            }
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            Set<PsiType> exceptionsHandled = ExceptionUtils.getExceptionTypesHandled(statement2);
            for (PsiType resourceException : ExceptionUtils.calculateExceptionsThrown((PsiElement)statement2.getResourceList())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, resourceException)) continue;
                this.m_exceptionsThrown.add(resourceException);
            }
            for (PsiType tryException : ExceptionUtils.calculateExceptionsThrown((PsiElement)statement2.getTryBlock())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, tryException)) continue;
                this.m_exceptionsThrown.add(tryException);
            }
            ExceptionUtils.calculateExceptionsThrown((PsiElement)statement2.getFinallyBlock(), this.m_exceptionsThrown);
            for (PsiCodeBlock catchBlock : statement2.getCatchBlocks()) {
                ExceptionUtils.calculateExceptionsThrown((PsiElement)catchBlock, this.m_exceptionsThrown);
            }
        }

        private static boolean isExceptionHandled(Set<PsiType> exceptionsHandled, @NotNull PsiType thrownType) {
            if (exceptionsHandled.contains(thrownType)) {
                return true;
            }
            for (PsiType exceptionHandled : exceptionsHandled) {
                if (!exceptionHandled.isAssignableFrom(thrownType)) continue;
                return true;
            }
            return false;
        }
    }
}

