/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplateStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean isElseIf(PsiIfStatement ifStatement) {
        PsiElement parent = ifStatement.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement parentStatement = (PsiIfStatement)parent;
        PsiStatement elseBranch = parentStatement.getElseBranch();
        return ifStatement.equals(elseBranch);
    }

    public static boolean statementMayCompleteNormally(@Nullable PsiStatement statement2) {
        if (statement2 == null) {
            return true;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiReturnStatement || statement2 instanceof PsiThrowStatement) {
            return false;
        }
        if (statement2 instanceof PsiExpressionListStatement || statement2 instanceof PsiEmptyStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiDeclarationStatement || statement2 instanceof PsiSwitchLabelStatement || statement2 instanceof PsiForeachStatement) {
            return true;
        }
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return true;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return true;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return true;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return true;
            }
            String className = aClass.getQualifiedName();
            return !"java.lang.System".equals(className);
        }
        if (statement2 instanceof PsiForStatement) {
            return ControlFlowUtils.forStatementMayCompleteNormally((PsiForStatement)statement2);
        }
        if (statement2 instanceof PsiWhileStatement) {
            return ControlFlowUtils.whileStatementMayCompleteNormally((PsiWhileStatement)statement2);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayCompleteNormally((PsiDoWhileStatement)statement2);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body = ((PsiSynchronizedStatement)statement2).getBody();
            return ControlFlowUtils.codeBlockMayCompleteNormally(body);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement2).getCodeBlock();
            return ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((PsiLabeledStatement)statement2);
        }
        if (statement2 instanceof PsiIfStatement) {
            return ControlFlowUtils.ifStatementMayCompleteNormally((PsiIfStatement)statement2);
        }
        if (statement2 instanceof PsiTryStatement) {
            return ControlFlowUtils.tryStatementMayCompleteNormally((PsiTryStatement)statement2);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            return ControlFlowUtils.switchStatementMayCompleteNormally((PsiSwitchStatement)statement2);
        }
        if (statement2 instanceof PsiTemplateStatement || statement2 instanceof PsiClassLevelDeclarationStatement) {
            return true;
        }
        assert (false) : "unknown statement type: " + statement2.getClass();
        return true;
    }

    private static boolean doWhileStatementMayCompleteNormally(@NotNull PsiDoWhileStatement loopStatement) {
        PsiExpression condition = loopStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        PsiStatement body = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body) && value != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement);
    }

    private static boolean whileStatementMayCompleteNormally(@NotNull PsiWhileStatement loopStatement) {
        PsiExpression condition = loopStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        return value != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement);
    }

    private static boolean forStatementMayCompleteNormally(@NotNull PsiForStatement loopStatement) {
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement)) {
            return true;
        }
        if (ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement)) {
            return true;
        }
        PsiExpression condition = loopStatement.getCondition();
        if (condition == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(condition);
        return Boolean.TRUE != value;
    }

    private static boolean switchStatementMayCompleteNormally(@NotNull PsiSwitchStatement switchStatement) {
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)switchStatement)) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return true;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return true;
        }
        int numCases = 0;
        boolean hasDefaultCase = false;
        for (PsiStatement statement2 : statements) {
            PsiBreakStatement breakStatement;
            PsiSwitchLabelStatement switchLabelStatement;
            if (statement2 instanceof PsiSwitchLabelStatement && (switchLabelStatement = (PsiSwitchLabelStatement)statement2).isDefaultCase()) {
                hasDefaultCase = true;
            }
            if (statement2 instanceof PsiBreakStatement && (breakStatement = (PsiBreakStatement)statement2).getLabelIdentifier() == null) {
                return true;
            }
            ++numCases;
        }
        boolean isEnum = ControlFlowUtils.isEnumSwitch(switchStatement);
        if (!hasDefaultCase && !isEnum) {
            return true;
        }
        if (!hasDefaultCase) {
            PsiExpression expression = switchStatement.getExpression();
            if (expression == null) {
                return true;
            }
            PsiClassType type = (PsiClassType)expression.getType();
            if (type == null) {
                return true;
            }
            PsiClass aClass = type.resolve();
            if (aClass == null) {
                return true;
            }
            PsiField[] fields = aClass.getFields();
            int numEnums = 0;
            for (PsiField field : fields) {
                PsiType fieldType = field.getType();
                if (!fieldType.equals(type)) continue;
                ++numEnums;
            }
            if (numEnums != numCases) {
                return true;
            }
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean isEnumSwitch(PsiSwitchStatement statement2) {
        PsiExpression expression = statement2.getExpression();
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        return aClass != null && aClass.isEnum();
    }

    private static boolean tryStatementMayCompleteNormally(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock[] catchBlocks;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && !ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.codeBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (!ControlFlowUtils.codeBlockMayCompleteNormally(catchBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayCompleteNormally(@NotNull PsiIfStatement ifStatement) {
        PsiStatement branch2;
        PsiStatement branch1;
        PsiExpression condition = ifStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (value == Boolean.TRUE) {
            return ControlFlowUtils.statementMayCompleteNormally(thenBranch);
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (value == Boolean.FALSE) {
            return ControlFlowUtils.statementMayCompleteNormally(elseBranch);
        }
        if ((thenBranch == null ? 0 : thenBranch.getTextLength()) < (elseBranch == null ? 0 : elseBranch.getTextLength())) {
            branch1 = thenBranch;
            branch2 = elseBranch;
        } else {
            branch2 = thenBranch;
            branch1 = elseBranch;
        }
        return ControlFlowUtils.statementMayCompleteNormally(branch1) || ControlFlowUtils.statementMayCompleteNormally(branch2);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull PsiLabeledStatement labeledStatement) {
        PsiStatement statement2 = labeledStatement.getStatement();
        if (statement2 == null) {
            return false;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement2) || ControlFlowUtils.statementIsBreakTarget(statement2);
    }

    public static boolean codeBlockMayCompleteNormally(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement2 : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement2)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull PsiStatement statement2) {
        BreakFinder breakFinder = new BreakFinder(statement2);
        statement2.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static boolean statementContainsContinueToAncestor(@NotNull PsiStatement statement2) {
        PsiElement parent = statement2.getParent();
        while (parent instanceof PsiLabeledStatement) {
            statement2 = (PsiStatement)parent;
            parent = parent.getParent();
        }
        ContinueToAncestorFinder continueToAncestorFinder = new ContinueToAncestorFinder(statement2);
        statement2.accept((PsiElementVisitor)continueToAncestorFinder);
        return continueToAncestorFinder.continueToAncestorFound();
    }

    public static boolean statementContainsReturn(@NotNull PsiStatement statement2) {
        ReturnFinder returnFinder = new ReturnFinder();
        statement2.accept((PsiElementVisitor)returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull PsiStatement statement2) {
        ContinueFinder continueFinder = new ContinueFinder(statement2);
        statement2.accept((PsiElementVisitor)continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean statementContainsSystemExit(@NotNull PsiStatement statement2) {
        SystemExitFinder systemExitFinder = new SystemExitFinder();
        statement2.accept((PsiElementVisitor)systemExitFinder);
        return systemExitFinder.exitFound();
    }

    public static boolean elementContainsCallToMethod(PsiElement context, String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        MethodCallFinder methodCallFinder = new MethodCallFinder(containingClassName, returnType, methodName, parameterTypes);
        context.accept((PsiElementVisitor)methodCallFinder);
        return methodCallFinder.containsCallToMethod();
    }

    public static boolean isInLoop(@NotNull PsiElement element) {
        PsiLoopStatement loopStatement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        if (loopStatement == null) {
            return false;
        }
        PsiStatement body = loopStatement.getBody();
        return body != null && PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static boolean isInFinallyBlock(@NotNull PsiElement element) {
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null && PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                PsiMethod elementMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiMethod.class);
                PsiMethod finallyMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)finallyBlock, PsiMethod.class);
                return elementMethod != null && elementMethod.equals(finallyMethod);
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiCatchSection.class, (boolean)true, (Class[])new Class[]{PsiClass.class}) != null;
    }

    public static boolean isInExitStatement(@NotNull PsiExpression expression) {
        return ControlFlowUtils.isInReturnStatementArgument(expression) || ControlFlowUtils.isInThrowStatementArgument(expression);
    }

    private static boolean isInReturnStatementArgument(@NotNull PsiExpression expression) {
        return PsiTreeUtil.getParentOfType((PsiElement)expression, PsiReturnStatement.class) != null;
    }

    private static boolean isInThrowStatementArgument(@NotNull PsiExpression expression) {
        return PsiTreeUtil.getParentOfType((PsiElement)expression, PsiThrowStatement.class) != null;
    }

    @Nullable
    public static PsiStatement stripBraces(@Nullable PsiStatement statement2) {
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)statement2;
            PsiStatement onlyStatement = ControlFlowUtils.getOnlyStatementInBlock(block.getCodeBlock());
            return onlyStatement != null ? onlyStatement : block;
        }
        return statement2;
    }

    public static boolean statementCompletesWithStatement(@NotNull PsiStatement containingStatement, @NotNull PsiStatement statement2) {
        PsiStatement statementToCheck = statement2;
        while (!statementToCheck.equals(containingStatement)) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiCodeBlock && !ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull PsiCodeBlock body, @NotNull PsiStatement statement2) {
        PsiStatement statementToCheck = statement2;
        while (statementToCheck != null) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            if (container instanceof PsiCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)container, PsiStatement.class);
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    @Nullable
    private static PsiElement getContainingStatementOrBlock(@NotNull PsiElement statement2) {
        return PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class});
    }

    private static boolean statementIsLastInBlock(@NotNull PsiCodeBlock block, @NotNull PsiStatement statement2) {
        for (PsiElement child = block.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiStatement)) continue;
            PsiStatement childStatement = (PsiStatement)child;
            if (statement2.equals(childStatement)) {
                return true;
            }
            if (statement2 instanceof PsiEmptyStatement) continue;
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiStatement getFirstStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return (PsiStatement)PsiTreeUtil.getChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    @Nullable
    public static PsiStatement getLastStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getLastChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    private static <T extends PsiElement> T getLastChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    public static PsiStatement getOnlyStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getOnlyChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    static <T extends PsiElement> T getOnlyChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            return null;
        }
        PsiElement result = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            if (result == null) {
                result = child;
                continue;
            }
            return null;
        }
        return (T)result;
    }

    public static boolean hasStatementCount(@Nullable PsiCodeBlock codeBlock, int count) {
        return ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)codeBlock, count, PsiStatement.class);
    }

    static <T extends PsiElement> boolean hasChildrenOfTypeCount(@Nullable PsiElement element, int count, @NotNull Class<T> aClass) {
        if (element == null) {
            return false;
        }
        int i = 0;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child) || ++i <= count) continue;
            return false;
        }
        return i == count;
    }

    public static boolean isEmptyCodeBlock(PsiCodeBlock codeBlock) {
        return ControlFlowUtils.hasStatementCount(codeBlock, 0);
    }

    public static boolean methodAlwaysThrowsException(@NotNull PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return true;
        }
        ReturnFinder returnFinder = new ReturnFinder();
        body.accept((PsiElementVisitor)returnFinder);
        return !returnFinder.returnFound() && !ControlFlowUtils.codeBlockMayCompleteNormally(body);
    }

    public static boolean statementContainsNakedBreak(PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        NakedBreakFinder breakFinder = new NakedBreakFinder();
        statement2.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static class ContinueToAncestorFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiStatement statement;
        private boolean found;

        private ContinueToAncestorFinder(PsiStatement statement2) {
            this.statement = statement2;
        }

        public void visitElement(PsiElement element) {
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitContinueStatement(PsiContinueStatement continueStatement) {
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            PsiStatement continuedStatement = continueStatement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.statement, (boolean)true)) {
                this.found = true;
            }
        }

        private boolean continueToAncestorFound() {
            return this.found;
        }
    }

    private static class MethodCallFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final String containingClassName;
        private final PsiType returnType;
        private final String methodName;
        private final PsiType[] parameterTypeNames;
        private boolean containsCallToMethod;

        private MethodCallFinder(String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypeNames) {
            this.containingClassName = containingClassName;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterTypeNames = parameterTypeNames;
        }

        public void visitElement(PsiElement element) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallToMethod(expression, this.containingClassName, this.returnType, this.methodName, this.parameterTypeNames)) {
                return;
            }
            this.containsCallToMethod = true;
        }

        private boolean containsCallToMethod() {
            return this.containsCallToMethod;
        }
    }

    private static class ContinueFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private ContinueFinder(@NotNull PsiStatement target) {
            this.m_target = target;
        }

        private boolean continueFound() {
            return this.m_found;
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement2) {
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(statement2);
            PsiStatement continuedStatement = statement2.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement2.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement2.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement2.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }
    }

    private static class BreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private BreakFinder(@NotNull PsiStatement target) {
            this.m_target = target;
        }

        private boolean breakFound() {
            return this.m_found;
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement2) {
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(statement2);
            PsiStatement exitedStatement = statement2.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement2.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement2.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement2.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }
    }

    private static class ReturnFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private ReturnFinder() {
        }

        private boolean returnFound() {
            return this.m_found;
        }

        public void visitClass(@NotNull PsiClass psiClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (this.m_found) {
                return;
            }
            super.visitReturnStatement(returnStatement);
            this.m_found = true;
        }
    }

    private static class SystemExitFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private SystemExitFinder() {
        }

        private boolean exitFound() {
            return this.m_found;
        }

        public void visitClass(@NotNull PsiClass aClass) {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (this.m_found) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.System".equals(className) && !"java.lang.Runtime".equals(className)) {
                return;
            }
            this.m_found = true;
        }
    }

    private static class NakedBreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private NakedBreakFinder() {
        }

        private boolean breakFound() {
            return this.m_found;
        }

        public void visitElement(PsiElement element) {
            if (this.m_found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        public void visitBreakStatement(PsiBreakStatement statement2) {
            if (statement2.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        }

        public void visitForStatement(PsiForStatement statement2) {
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
        }

        public void visitSwitchStatement(PsiSwitchStatement statement2) {
        }
    }
}

