/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonUtils {
    private static final Set<IElementType> s_comparisonTokens = new HashSet<IElementType>(6);
    private static final Map<IElementType, String> s_swappedComparisons = new HashMap<IElementType, String>(6);
    private static final Map<IElementType, String> s_invertedComparisons = new HashMap<IElementType, String>(6);

    private ComparisonUtils() {
    }

    public static boolean isComparison(@Nullable PsiExpression expression) {
        if (!(expression instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        return ComparisonUtils.isComparisonOperation(tokenType);
    }

    public static boolean isComparisonOperation(IElementType tokenType) {
        return s_comparisonTokens.contains(tokenType);
    }

    public static String getFlippedComparison(IElementType tokenType) {
        return s_swappedComparisons.get(tokenType);
    }

    public static boolean isEqualityComparison(@NotNull PsiExpression expression) {
        if (!(expression instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        return tokenType.equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE);
    }

    public static String getNegatedComparison(IElementType tokenType) {
        return s_invertedComparisons.get(tokenType);
    }

    static {
        s_comparisonTokens.add(JavaTokenType.EQEQ);
        s_comparisonTokens.add(JavaTokenType.NE);
        s_comparisonTokens.add(JavaTokenType.GT);
        s_comparisonTokens.add(JavaTokenType.LT);
        s_comparisonTokens.add(JavaTokenType.GE);
        s_comparisonTokens.add(JavaTokenType.LE);
        s_swappedComparisons.put(JavaTokenType.EQEQ, "==");
        s_swappedComparisons.put(JavaTokenType.NE, "!=");
        s_swappedComparisons.put(JavaTokenType.GT, "<");
        s_swappedComparisons.put(JavaTokenType.LT, ">");
        s_swappedComparisons.put(JavaTokenType.GE, "<=");
        s_swappedComparisons.put(JavaTokenType.LE, ">=");
        s_invertedComparisons.put(JavaTokenType.EQEQ, "!=");
        s_invertedComparisons.put(JavaTokenType.NE, "==");
        s_invertedComparisons.put(JavaTokenType.GT, "<=");
        s_invertedComparisons.put(JavaTokenType.LT, ">=");
        s_invertedComparisons.put(JavaTokenType.GE, "<");
        s_invertedComparisons.put(JavaTokenType.LE, ">");
    }
}

