/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull PsiExpression expression) {
        if (!(expression instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExp.getOperationTokenType();
        return JavaTokenType.EXCL.equals(tokenType);
    }

    public static boolean isNegated(PsiExpression exp) {
        PsiExpression ancestor = exp;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
    }

    @Nullable
    public static PsiExpression getNegated(PsiExpression expression) {
        if (!(expression instanceof PsiPrefixExpression)) {
            return null;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!JavaTokenType.EXCL.equals(tokenType)) {
            return null;
        }
        PsiExpression operand = prefixExpression.getOperand();
        return ParenthesesUtils.stripParentheses(operand);
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression condition) {
        return BoolUtils.getNegatedExpressionText(condition, 17);
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression expression, int precedence) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return "";
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            return conditionalExpression.getCondition().getText() + '?' + BoolUtils.getNegatedExpressionText(conditionalExpression.getThenExpression()) + ':' + BoolUtils.getNegatedExpressionText(conditionalExpression.getElseExpression());
        }
        if (BoolUtils.isNegation(expression)) {
            PsiExpression negated = BoolUtils.getNegated(expression);
            if (negated == null) {
                return "";
            }
            return ParenthesesUtils.getText(negated, precedence);
        }
        if (ComparisonUtils.isComparison(expression)) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            String negatedComparison = ComparisonUtils.getNegatedComparison(polyadicExpression.getOperationTokenType());
            StringBuilder result = new StringBuilder();
            PsiExpression[] operands = polyadicExpression.getOperands();
            boolean isEven = (operands.length & 1) != 1;
            int length = operands.length;
            for (int i = 0; i < length; ++i) {
                PsiExpression operand = operands[i];
                if (i > 0) {
                    if (isEven && (i & 1) != 1) {
                        PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand);
                        if (token != null) {
                            result.append(token.getText());
                        }
                    } else {
                        result.append(negatedComparison);
                    }
                }
                result.append(operand.getText());
            }
            return result.toString();
        }
        return '!' + ParenthesesUtils.getText(expression, 3);
    }

    @Nullable
    public static PsiExpression findNegation(PsiExpression expression) {
        PsiPrefixExpression prefixAncestor;
        PsiExpression ancestor = expression;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        if (parent instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixAncestor = (PsiPrefixExpression)parent).getOperationTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isBooleanLiteral(PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
        String text = literalExpression.getText();
        return "true".equals(text) || "false".equals(text);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isTrue(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return false;
        }
        return "true".equals(expression.getText());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isFalse(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return false;
        }
        return "false".equals(expression.getText());
    }
}

