/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class ArrayContentsAccessedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean accessed;
    private final PsiVariable variable;

    ArrayContentsAccessedVisitor(@NotNull PsiVariable variable) {
        this.variable = variable;
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement2) {
        if (this.accessed) {
            return;
        }
        super.visitForeachStatement(statement2);
        PsiExpression qualifier = statement2.getIteratedValue();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement target = referenceExpression.resolve();
        if (this.variable.equals(target)) {
            this.accessed = true;
        }
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression arrayAccessExpression) {
        PsiAssignmentExpression assignmentExpression;
        PsiExpression lhs;
        if (this.accessed) {
            return;
        }
        super.visitArrayAccessExpression(arrayAccessExpression);
        PsiElement parent = arrayAccessExpression.getParent();
        if (parent instanceof PsiAssignmentExpression && (lhs = (assignmentExpression = (PsiAssignmentExpression)parent).getLExpression()).equals(arrayAccessExpression)) {
            return;
        }
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
        PsiElement target = referenceExpression.resolve();
        if (this.variable.equals(target)) {
            this.accessed = true;
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        if (this.accessed) {
            return;
        }
        super.visitReferenceExpression(expression);
        String referenceName = expression.getReferenceName();
        if (!"length".equals(referenceName)) {
            return;
        }
        PsiExpression qualifier = expression.getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement target = referenceExpression.resolve();
        if (this.variable.equals(target)) {
            this.accessed = true;
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        if (this.accessed) {
            return;
        }
        super.visitMethodCallExpression(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"clone".equals(methodName)) {
            return;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        if (argumentList.getExpressions().length != 0) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement target = referenceExpression.resolve();
        if (this.variable.equals(target)) {
            this.accessed = true;
        }
    }

    public boolean isAccessed() {
        return this.accessed;
    }
}

