/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class HardcodedLineSeparatorsInspection
extends BaseInspection {
    private static final Pattern newlines = Pattern.compile("\\\\n|\\\\r|\\\\0{0,1}12|\\\\0{0,1}15");

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("hardcoded.line.separator.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "HardcodedLineSeparator";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("hardcoded.line.separator.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HardcodedLineSeparatorsVisitor();
    }

    private static class HardcodedLineSeparatorsVisitor
    extends BaseInspectionVisitor {
        private HardcodedLineSeparatorsVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (type == null || !TypeUtils.isJavaLangString(type) && !type.equals(PsiType.CHAR)) {
                return;
            }
            String text = expression.getText();
            Matcher matcher = newlines.matcher(text);
            int end = 0;
            while (matcher.find(end)) {
                int start = matcher.start();
                end = matcher.end();
                this.registerErrorAtOffset((PsiElement)expression, start, end - start, new Object[0]);
            }
        }
    }
}

