/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.performance.ToArrayCallWithZeroLengthArrayArgumentInspectionBase;
import com.siyeh.ig.psiutils.HighlightUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToArrayCallWithZeroLengthArrayArgumentInspection
extends ToArrayCallWithZeroLengthArrayArgumentInspectionBase {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ToArrayCallWithZeroLengthArrayArgumentFix();
    }

    private static class ToArrayCallWithZeroLengthArrayArgumentFix
    extends InspectionGadgetsFix {
        private ToArrayCallWithZeroLengthArrayArgumentFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("to.array.call.with.zero.length.array.argument.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (qualifier == null) {
                return;
            }
            String collectionText = qualifier.getText();
            PsiType type = argument.getType();
            if (type == null) {
                return;
            }
            PsiType componentType = type.getDeepComponentType();
            String typeText = componentType.getCanonicalText();
            if (!(qualifier instanceof PsiMethodCallExpression)) {
                String replacementText = "new " + typeText + '[' + collectionText + ".size()]";
                String newExpressionText = PsiReplacementUtil.getElementText((PsiElement)methodCallExpression, (PsiElement)argument, replacementText);
                PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpressionText);
                return;
            }
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiStatement.class);
            if (statement2 == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return;
            }
            PsiDeclarationStatement declarationStatement = factory.createVariableDeclarationStatement("var", qualifierType, qualifier);
            PsiElement statementParent = statement2.getParent();
            while (statementParent instanceof PsiLoopStatement || statementParent instanceof PsiIfStatement) {
                statement2 = (PsiStatement)statementParent;
                statementParent = statement2.getParent();
            }
            String toArrayText = "var.toArray(new " + typeText + "[var.size()])";
            PsiMethodCallExpression newMethodCallExpression = (PsiMethodCallExpression)factory.createExpressionFromText(toArrayText, (PsiElement)methodCallExpression);
            declarationStatement = (PsiDeclarationStatement)statementParent.addBefore((PsiElement)declarationStatement, (PsiElement)statement2);
            newMethodCallExpression = (PsiMethodCallExpression)methodCallExpression.replace((PsiElement)newMethodCallExpression);
            this.showRenameTemplate(declarationStatement, newMethodCallExpression, statementParent);
        }

        private void showRenameTemplate(PsiDeclarationStatement declarationStatement, PsiMethodCallExpression methodCallExpression, PsiElement context) {
            if (!this.isOnTheFly()) {
                return;
            }
            PsiVariable variable = (PsiVariable)declarationStatement.getDeclaredElements()[0];
            PsiReferenceExpression ref1 = (PsiReferenceExpression)methodCallExpression.getMethodExpression().getQualifierExpression();
            PsiNewExpression argument = (PsiNewExpression)methodCallExpression.getArgumentList().getExpressions()[0];
            PsiMethodCallExpression sizeExpression = (PsiMethodCallExpression)argument.getArrayDimensions()[0];
            PsiReferenceExpression ref2 = (PsiReferenceExpression)sizeExpression.getMethodExpression().getQualifierExpression();
            HighlightUtils.showRenameTemplate(context, (PsiNameIdentifierOwner)variable, new PsiReference[]{ref1, ref2});
        }
    }
}

