/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TailRecursionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("tail.recursion.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("tail.recursion.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod containingMethod = (PsiMethod)infos[0];
        if (!TailRecursionInspection.mayBeReplacedByIterativeMethod(containingMethod)) {
            return null;
        }
        return new RemoveTailRecursionFix();
    }

    private static boolean mayBeReplacedByIterativeMethod(PsiMethod containingMethod) {
        PsiParameter[] parameters;
        PsiParameterList parameterList = containingMethod.getParameterList();
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            if (!parameter.hasModifierProperty("final")) continue;
            return false;
        }
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TailRecursionVisitor();
    }

    private static class TailRecursionVisitor
    extends BaseInspectionVisitor {
        private TailRecursionVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement2) {
            super.visitReturnStatement(statement2);
            PsiExpression returnValue = statement2.getReturnValue();
            if (!(returnValue instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression returnCall = (PsiMethodCallExpression)returnValue;
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (containingMethod == null) {
                return;
            }
            PsiReferenceExpression methodExpression = returnCall.getMethodExpression();
            String name = containingMethod.getName();
            if (!name.equals(methodExpression.getReferenceName())) {
                return;
            }
            PsiMethod method = returnCall.resolveMethod();
            if (method == null) {
                return;
            }
            if (!method.equals(containingMethod)) {
                return;
            }
            this.registerMethodCallError(returnCall, containingMethod);
        }
    }

    private static class RemoveTailRecursionFix
    extends InspectionGadgetsFix {
        private RemoveTailRecursionFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("tail.recursion.replace.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            boolean tailCallIsContainedInLoop;
            String thisVariableName;
            PsiElement tailCallToken = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)tailCallToken, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (method == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
            if (RemoveTailRecursionFix.methodReturnsContainingClassType(method, containingClass)) {
                builder.append(containingClass.getName());
                thisVariableName = styleManager.suggestUniqueVariableName("result", (PsiElement)method, false);
                builder.append(' ');
                builder.append(thisVariableName);
                builder.append(" = this;");
            } else if (RemoveTailRecursionFix.methodContainsCallOnOtherInstance(method)) {
                builder.append(containingClass.getName());
                thisVariableName = styleManager.suggestUniqueVariableName("other", (PsiElement)method, false);
                builder.append(' ');
                builder.append(thisVariableName);
                builder.append(" = this;");
            } else {
                thisVariableName = null;
            }
            if (ControlFlowUtils.isInLoop(tailCallToken)) {
                tailCallIsContainedInLoop = true;
                builder.append(method.getName());
                builder.append(':');
            } else {
                tailCallIsContainedInLoop = false;
            }
            builder.append("while(true)");
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
            RemoveTailRecursionFix.replaceTailCalls((PsiElement)body, method, thisVariableName, tailCallIsContainedInLoop, builder);
            builder.append('}');
            String replacementText = builder.toString();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory elementFactory = psiFacade.getElementFactory();
            PsiCodeBlock block = elementFactory.createCodeBlockFromText(replacementText, (PsiElement)method);
            body.replace((PsiElement)block);
            codeStyleManager.reformat((PsiElement)method);
        }

        private static boolean methodReturnsContainingClassType(PsiMethod method, PsiClass containingClass) {
            if (containingClass == null) {
                return false;
            }
            if (method.hasModifierProperty("static")) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            if (!(returnType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)returnType;
            PsiClass aClass = classType.resolve();
            return containingClass.equals(aClass);
        }

        private static boolean methodContainsCallOnOtherInstance(PsiMethod method) {
            if (method.hasModifierProperty("static")) {
                return false;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            MethodContainsCallOnOtherInstanceVisitor visitor = new MethodContainsCallOnOtherInstanceVisitor(aClass);
            body.accept((PsiElementVisitor)visitor);
            return visitor.containsCallOnOtherInstance();
        }

        private static void replaceTailCalls(PsiElement element, PsiMethod method, @Nullable String thisVariableName, boolean tailCallIsContainedInLoop, @NonNls StringBuilder out) {
            String text = element.getText();
            if (RemoveTailRecursionFix.isImplicitCallOnThis(element, method)) {
                if (thisVariableName != null) {
                    out.append(thisVariableName);
                    out.append('.');
                }
                out.append(text);
            } else if (element instanceof PsiThisExpression || element instanceof PsiSuperExpression) {
                if (thisVariableName == null) {
                    out.append(text);
                } else {
                    out.append(thisVariableName);
                }
            } else if (RemoveTailRecursionFix.isTailCallReturn(element, method)) {
                PsiReferenceExpression methodExpression;
                PsiExpression qualifier;
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                PsiMethodCallExpression call = (PsiMethodCallExpression)returnStatement.getReturnValue();
                assert (call != null);
                PsiExpressionList argumentList = call.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                PsiParameterList parameterList = method.getParameterList();
                PsiParameter[] parameters = parameterList.getParameters();
                boolean isInBlock = returnStatement.getParent() instanceof PsiCodeBlock;
                if (!isInBlock) {
                    out.append('{');
                }
                for (int i = 0; i < parameters.length; ++i) {
                    String argumentText;
                    PsiParameter parameter = parameters[i];
                    PsiExpression argument = arguments[i];
                    String parameterName = parameter.getName();
                    if (parameterName == null || parameterName.equals(argumentText = argument.getText())) continue;
                    out.append(parameterName);
                    out.append(" = ");
                    out.append(argumentText);
                    out.append(';');
                }
                if (thisVariableName != null && (qualifier = (methodExpression = call.getMethodExpression()).getQualifierExpression()) != null) {
                    out.append(thisVariableName);
                    out.append(" = ");
                    RemoveTailRecursionFix.replaceTailCalls((PsiElement)qualifier, method, thisVariableName, tailCallIsContainedInLoop, out);
                    out.append(';');
                }
                PsiCodeBlock body = method.getBody();
                assert (body != null);
                if (!ControlFlowUtils.blockCompletesWithStatement(body, (PsiStatement)returnStatement)) {
                    if (tailCallIsContainedInLoop) {
                        String methodName = method.getName();
                        out.append("continue ");
                        out.append(methodName);
                        out.append(';');
                    } else {
                        out.append("continue;");
                    }
                }
                if (!isInBlock) {
                    out.append('}');
                }
            } else {
                PsiElement[] children2 = element.getChildren();
                if (children2.length == 0) {
                    out.append(text);
                } else {
                    for (PsiElement child : children2) {
                        RemoveTailRecursionFix.replaceTailCalls(child, method, thisVariableName, tailCallIsContainedInLoop, out);
                    }
                }
            }
        }

        private static boolean isImplicitCallOnThis(PsiElement element, PsiMethod containingMethod) {
            if (containingMethod.hasModifierProperty("static")) {
                return false;
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                return qualifierExpression == null;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement parent = referenceExpression.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    return false;
                }
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                if (qualifier != null) {
                    return false;
                }
                PsiElement target = referenceExpression.resolve();
                return target instanceof PsiField;
            }
            return false;
        }

        private static boolean isTailCallReturn(PsiElement element, PsiMethod containingMethod) {
            if (!(element instanceof PsiReturnStatement)) {
                return false;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)element;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (!(returnValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)returnValue;
            PsiMethod method = call.resolveMethod();
            return containingMethod.equals(method);
        }

        private static class MethodContainsCallOnOtherInstanceVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private boolean containsCallOnOtherInstance;
            private final PsiClass aClass;

            private MethodContainsCallOnOtherInstanceVisitor(PsiClass aClass) {
                this.aClass = aClass;
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                if (this.containsCallOnOtherInstance) {
                    return;
                }
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (this.aClass.equals(containingClass)) {
                    this.containsCallOnOtherInstance = true;
                }
            }

            private boolean containsCallOnOtherInstance() {
                return this.containsCallOnOtherInstance;
            }
        }
    }
}

