/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class StringEqualsEmptyStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.equals.empty.string.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean useIsEmpty = (Boolean)infos[0];
        if (useIsEmpty) {
            return InspectionGadgetsBundle.message("string.equals.empty.string.is.empty.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("string.equals.empty.string.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        boolean useIsEmpty = (Boolean)infos[0];
        return new StringEqualsEmptyStringFix(useIsEmpty);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsEmptyStringVisitor();
    }

    private static class StringEqualsEmptyStringVisitor
    extends BaseInspectionVisitor {
        private StringEqualsEmptyStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement context = call.getParent();
            boolean useIsEmpty = PsiUtil.isLanguageLevel6OrHigher((PsiElement)call);
            if (!useIsEmpty && context instanceof PsiExpressionStatement) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression argument = arguments[0];
            if (ExpressionUtils.isEmptyStringLiteral(qualifier)) {
                PsiType type = argument.getType();
                if (!TypeUtils.isJavaLangString(type)) {
                    return;
                }
            } else if (ExpressionUtils.isEmptyStringLiteral(argument)) {
                if (qualifier == null) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (!TypeUtils.isJavaLangString(type)) {
                    return;
                }
            } else {
                return;
            }
            this.registerMethodCallError(call, useIsEmpty);
        }
    }

    private static class StringEqualsEmptyStringFix
    extends InspectionGadgetsFix {
        private final boolean useIsEmpty;

        public StringEqualsEmptyStringFix(boolean useIsEmpty) {
            this.useIsEmpty = useIsEmpty;
        }

        @NotNull
        public String getName() {
            if (this.useIsEmpty) {
                return InspectionGadgetsBundle.message("string.equals.empty.string.isempty.quickfix", new Object[0]);
            }
            return InspectionGadgetsBundle.message("string.equals.empty.string.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify empty string check";
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression expressionToReplace;
            StringBuilder newExpression;
            boolean addNullCheck;
            PsiExpression checkedExpression;
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            if (expression == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression.getParent();
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression qualifier = expression.getQualifierExpression();
            PsiExpression argument = arguments[0];
            if (ExpressionUtils.isEmptyStringLiteral(argument)) {
                checkedExpression = this.getCheckedExpression(qualifier);
                addNullCheck = false;
            } else {
                checkedExpression = this.getCheckedExpression(argument);
                boolean bl = addNullCheck = !StringEqualsEmptyStringFix.isCheckedForNull(checkedExpression);
            }
            if (addNullCheck) {
                newExpression = new StringBuilder(checkedExpression.getText());
                newExpression.append("!=null&&");
            } else {
                newExpression = new StringBuilder("");
            }
            PsiElement parent = call.getParent();
            if (parent instanceof PsiExpression) {
                PsiExpression parentExpression = (PsiExpression)parent;
                if (BoolUtils.isNegation(parentExpression)) {
                    expressionToReplace = parentExpression;
                    if (this.useIsEmpty) {
                        newExpression.append('!').append(checkedExpression.getText()).append(".isEmpty()");
                    } else {
                        newExpression.append(checkedExpression.getText()).append(".length()!=0");
                    }
                } else {
                    expressionToReplace = call;
                    if (this.useIsEmpty) {
                        newExpression.append(checkedExpression.getText()).append(".isEmpty()");
                    } else {
                        newExpression.append(checkedExpression.getText()).append(".length()==0");
                    }
                }
            } else {
                expressionToReplace = call;
                if (this.useIsEmpty) {
                    newExpression.append(checkedExpression.getText()).append(".isEmpty()");
                } else {
                    newExpression.append(checkedExpression.getText()).append(".length()==0");
                }
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expressionToReplace, newExpression.toString());
        }

        private static boolean isCheckedForNull(PsiExpression expression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiPolyadicExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class, PsiVariable.class});
            if (polyadicExpression == null) {
                return false;
            }
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (PsiTreeUtil.isAncestor((PsiElement)operand, (PsiElement)expression, (boolean)true)) {
                    return false;
                }
                if (!(operand instanceof PsiBinaryExpression)) continue;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
                IElementType operationTokenType = binaryExpression.getOperationTokenType();
                if (JavaTokenType.ANDAND.equals(tokenType) ? !JavaTokenType.NE.equals(operationTokenType) : !JavaTokenType.OROR.equals(tokenType) || !JavaTokenType.EQEQ.equals(operationTokenType)) continue;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) continue;
                if (PsiType.NULL.equals((Object)lhs.getType()) && EquivalenceChecker.expressionsAreEquivalent(expression, rhs)) {
                    return true;
                }
                if (!PsiType.NULL.equals((Object)rhs.getType()) || !EquivalenceChecker.expressionsAreEquivalent(expression, lhs)) continue;
                return true;
            }
            return false;
        }

        private PsiExpression getCheckedExpression(PsiExpression expression) {
            if (this.useIsEmpty || !(expression instanceof PsiMethodCallExpression)) {
                return expression;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return expression;
            }
            PsiType type = qualifierExpression.getType();
            if ("toString".equals(referenceName) && type != null && (type.equalsToText("java.lang.StringBuffer") || type.equalsToText("java.lang.StringBuilder"))) {
                return qualifierExpression;
            }
            return expression;
        }
    }
}

