/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantStringFormatCallInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("redundant.string.format.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("redundant.string.format.call.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantStringFormatCallFix();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantStringFormatCallVisitor();
    }

    private static class RedundantStringFormatCallVisitor
    extends BaseInspectionVisitor {
        private RedundantStringFormatCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"format".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 2 || arguments.length == 0) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            PsiType firstType = firstArgument.getType();
            if (firstType == null) {
                return;
            }
            if (firstType.equalsToText("java.lang.String")) {
                if (arguments.length == 1 && !RedundantStringFormatCallVisitor.containsPercentN(firstArgument)) {
                    this.registerMethodCallError(expression, new Object[0]);
                }
            } else if (firstType.equalsToText("java.util.Locale")) {
                if (arguments.length != 2) {
                    return;
                }
                PsiExpression secondArgument = arguments[1];
                PsiType secondType = secondArgument.getType();
                if (secondType == null || !secondType.equalsToText("java.lang.String")) {
                    return;
                }
                if (RedundantStringFormatCallVisitor.containsPercentN(secondArgument)) {
                    return;
                }
                this.registerMethodCallError(expression, new Object[0]);
            }
        }

        private static boolean containsPercentN(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
                String expressionText = literalExpression.getText();
                return expressionText.contains("%n");
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiExpression[] operands;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                if (!tokenType.equals(JavaTokenType.PLUS)) {
                    return false;
                }
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    if (!RedundantStringFormatCallVisitor.containsPercentN(operand)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class RedundantStringFormatCallFix
    extends InspectionGadgetsFix {
        private RedundantStringFormatCallFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("redundant.string.format.call.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression lastArgument = arguments[arguments.length - 1];
            methodCallExpression.replace((PsiElement)lastArgument);
        }
    }
}

