/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomDoubleForRandomIntegerInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "UsingRandomNextDoubleForRandomInteger";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("random.double.for.random.integer.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("random.double.for.random.integer.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RandomDoubleForRandomIntegerFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RandomDoubleForRandomIntegerVisitor();
    }

    @Nullable
    static PsiExpression getContainingExpression(PsiExpression expression) {
        PsiElement ancestor = expression.getParent();
        while (ancestor != null) {
            if (!(ancestor instanceof PsiExpression)) {
                return null;
            }
            if (!(ancestor instanceof PsiParenthesizedExpression)) {
                return (PsiExpression)ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    private static class RandomDoubleForRandomIntegerVisitor
    extends BaseInspectionVisitor {
        private RandomDoubleForRandomIntegerVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String nextDouble = "nextDouble";
            if (!"nextDouble".equals(methodName)) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.util.Random".equals(className)) {
                return;
            }
            PsiExpression possibleMultiplierExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)call);
            if (!RandomDoubleForRandomIntegerVisitor.isMultiplier(possibleMultiplierExpression)) {
                return;
            }
            PsiExpression possibleIntCastExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression(possibleMultiplierExpression);
            if (!RandomDoubleForRandomIntegerVisitor.isIntCast(possibleIntCastExpression)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static boolean isMultiplier(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.ASTERISK.equals(tokenType);
        }

        private static boolean isIntCast(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof PsiTypeCastExpression)) {
                return false;
            }
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)expression;
            PsiType type = castExpression.getType();
            return PsiType.INT.equals((Object)type);
        }
    }

    private static class RandomDoubleForRandomIntegerFix
    extends InspectionGadgetsFix {
        private RandomDoubleForRandomIntegerFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("random.double.for.random.integer.replace.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            if (expression == null) {
                return;
            }
            PsiExpression call = (PsiExpression)expression.getParent();
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String qualifierText = qualifier.getText();
            PsiBinaryExpression multiplication = (PsiBinaryExpression)RandomDoubleForRandomIntegerInspection.getContainingExpression(call);
            if (multiplication == null) {
                return;
            }
            PsiExpression cast = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)multiplication);
            if (cast == null) {
                return;
            }
            PsiExpression lhs = multiplication.getLOperand();
            PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
            PsiExpression multiplierExpression = call.equals(strippedLhs) ? multiplication.getROperand() : lhs;
            assert (multiplierExpression != null);
            String multiplierText = multiplierExpression.getText();
            String nextInt = ".nextInt((int) ";
            PsiReplacementUtil.replaceExpression(cast, qualifierText + ".nextInt((int) " + multiplierText + ')');
        }
    }
}

