/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class EqualsHashCodeCalledOnUrlInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("equals.hashcode.called.on.url.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("equals.hashcode.called.on.url.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsHashCodeCalledOnUrlVisitor();
    }

    private static class EqualsHashCodeCalledOnUrlVisitor
    extends BaseInspectionVisitor {
        private EqualsHashCodeCalledOnUrlVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiMethod method = expression.resolveMethod();
            if (!MethodUtils.isEquals(method) && !MethodUtils.isHashCode(method)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!ExpressionUtils.hasType(qualifier, "java.net.URL")) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

