/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.performance.CollectionsListSettings;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionsMustHaveInitialCapacityInspection
extends BaseInspection {
    private final CollectionsListSettings mySettings = new CollectionsListSettings(){

        protected Set<String> getDefaultSettings() {
            TreeSet<String> classes = new TreeSet<String>(DEFAULT_COLLECTION_LIST);
            classes.add("java.util.BitSet");
            return classes;
        }
    };

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        this.mySettings.readSettings(node);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.mySettings.writeSettings(node);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.mySettings.createOptionsPanel();
    }

    @NotNull
    public String getID() {
        return "CollectionWithoutInitialCapacity";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("collections.must.have.initial.capacity.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("collections.must.have.initial.capacity.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionInitialCapacityVisitor();
    }

    private class CollectionInitialCapacityVisitor
    extends BaseInspectionVisitor {
        private CollectionInitialCapacityVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!this.isCollectionWithInitialCapacity(type)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null || argumentList.getExpressions().length != 0) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        private boolean isCollectionWithInitialCapacity(@Nullable PsiType type) {
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass resolved = classType.resolve();
            if (resolved == null) {
                return false;
            }
            String className = resolved.getQualifiedName();
            return CollectionsMustHaveInitialCapacityInspection.this.mySettings.getCollectionClassesRequiringCapacity().contains(className);
        }
    }
}

