/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BooleanConstructorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "BooleanConstructorCall";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("boolean.constructor.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("boolean.constructor.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new BooleanConstructorFix();
    }

    private static class BooleanConstructorVisitor
    extends BaseInspectionVisitor {
        private BooleanConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            String qualifiedName;
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (type == null || !type.equalsToText("java.lang.Boolean")) {
                return;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)expression);
            if (aClass != null && "java.lang.Boolean".equals(qualifiedName = aClass.getQualifiedName())) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 1) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }
    }

    private static class BooleanConstructorFix
    extends InspectionGadgetsFix {
        private static final String TRUE = "\"true\"";
        private static final String FALSE = "\"false\"";

        private BooleanConstructorFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("boolean.constructor.simplify.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            String newExpression;
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression expression = (PsiNewExpression)element;
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            String text = argument.getText();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)expression);
            if ("true".equals(text) || TRUE.equalsIgnoreCase(text)) {
                newExpression = "java.lang.Boolean.TRUE";
            } else if ("false".equals(text) || FALSE.equalsIgnoreCase(text)) {
                newExpression = "java.lang.Boolean.FALSE";
            } else if (languageLevel.equals((Object)LanguageLevel.JDK_1_3)) {
                newExpression = BooleanConstructorFix.buildText(argument, false);
            } else {
                PsiClass booleanClass = ClassUtils.findClass("java.lang.Boolean", (PsiElement)argument);
                boolean methodFound = false;
                if (booleanClass != null) {
                    PsiMethod[] methods;
                    for (PsiMethod method : methods = booleanClass.findMethodsByName("valueOf", false)) {
                        PsiParameter parameter;
                        PsiType type;
                        PsiParameterList parameterList = method.getParameterList();
                        PsiParameter[] parameters = parameterList.getParameters();
                        if (parameters.length == 0 || !PsiType.BOOLEAN.equals((Object)(type = (parameter = parameters[0]).getType()))) continue;
                        methodFound = true;
                        break;
                    }
                }
                newExpression = BooleanConstructorFix.buildText(argument, methodFound);
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression);
        }

        @NonNls
        private static String buildText(PsiExpression argument, boolean useValueOf) {
            String text = argument.getText();
            PsiType argumentType = argument.getType();
            if (!useValueOf && PsiType.BOOLEAN.equals((Object)argumentType)) {
                if (ParenthesesUtils.getPrecedence(argument) > 15) {
                    return text + "?java.lang.fBoolean.TRUE:java.lang.Boolean.FALSE";
                }
                return '(' + text + ")?java.lang.Boolean.TRUE:java.lang.Boolean.FALSE";
            }
            return "java.lang.Boolean.valueOf(" + text + ')';
        }
    }
}

