/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArraysAsListWithZeroOrOneArgumentInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("arrays.as.list.with.zero.or.one.argument.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean isEmpty = (Boolean)infos[0];
        if (isEmpty.booleanValue()) {
            return InspectionGadgetsBundle.message("arrays.as.list.with.zero.arguments.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("arrays.as.list.with.one.argument.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean isEmpty = (Boolean)infos[0];
        return new ArraysAsListWithOneArgumentFix(isEmpty);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayAsListWithOneArgumentVisitor();
    }

    private static class ArrayAsListWithOneArgumentVisitor
    extends BaseInspectionVisitor {
        private ArrayAsListWithOneArgumentVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiExpression argument;
            PsiType type;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"asList".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 1 ? (type = (argument = arguments[0]).getType()) instanceof PsiArrayType : arguments.length != 0) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.util.Arrays".equals(className)) {
                return;
            }
            this.registerMethodCallError(expression, arguments.length == 0);
        }
    }

    private static class ArraysAsListWithOneArgumentFix
    extends InspectionGadgetsFix {
        private final boolean myEmpty;

        private ArraysAsListWithOneArgumentFix(boolean isEmpty) {
            this.myEmpty = isEmpty;
        }

        @NotNull
        public String getName() {
            if (this.myEmpty) {
                return InspectionGadgetsBundle.message("arrays.as.list.with.zero.arguments.quickfix", new Object[0]);
            }
            return InspectionGadgetsBundle.message("arrays.as.list.with.one.argument.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement().getParent().getParent();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            if (this.myEmpty) {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, "java.util.Collections.emptyList()");
            } else {
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiReferenceParameterList parameterList = methodExpression.getParameterList();
                String parameterText = parameterList != null ? parameterList.getText() : "";
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, "java.util.Collections." + parameterText + "singletonList" + argumentList.getText());
            }
        }
    }
}

