/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefPackage;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageInMultipleModulesInspection
extends BaseGlobalInspection {
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("package.in.multiple.modules.display.name", new Object[0]);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        List children2 = refEntity.getChildren();
        if (children2 == null) {
            return null;
        }
        HashSet<RefModule> modules = new HashSet<RefModule>();
        for (RefEntity child : children2) {
            if (!(child instanceof RefClass)) continue;
            RefClass refClass = (RefClass)child;
            RefModule module2 = refClass.getModule();
            modules.add(module2);
        }
        if (modules.size() <= 1) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("package.in.multiple.modules.problem.descriptor", refEntity.getQualifiedName());
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }
}

