/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUnconnectedToPackageInspection
extends BaseGlobalInspection {
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("class.unconnected.to.package.display.name", new Object[0]);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        RefEntity owner = refClass.getOwner();
        if (!(owner instanceof RefPackage)) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
        for (RefClass refClass2 : dependencies) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, refClass2)) continue;
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        for (RefClass dependent : dependents) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, dependent)) continue;
            return null;
        }
        PsiClass psiClass = refClass.getElement();
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("class.unconnected.to.package.problem.descriptor", new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
    }

    private static boolean inSamePackage(RefClass class1, RefClass class2) {
        return class1.getOwner() == class2.getOwner();
    }
}

