/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.numeric.ConvertOctalLiteralToDecimalFix;
import com.siyeh.ig.numeric.RemoveLeadingZeroFix;
import org.jetbrains.annotations.NotNull;

public class OctalAndDecimalIntegersMixedInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "OctalAndDecimalIntegersInSameArray";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("octal.and.decimal.integers.in.same.array.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("octal.and.decimal.integers.in.same.array.problem.descriptor", new Object[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        return new InspectionGadgetsFix[]{new ConvertOctalLiteralToDecimalFix(), new RemoveLeadingZeroFix()};
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OctalAndDecimalIntegersMixedVisitor();
    }

    private static class OctalAndDecimalIntegersMixedVisitor
    extends BaseInspectionVisitor {
        private OctalAndDecimalIntegersMixedVisitor() {
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            super.visitArrayInitializerExpression(expression);
            PsiExpression[] initializers = expression.getInitializers();
            boolean hasDecimalLiteral = false;
            boolean hasOctalLiteral = false;
            for (PsiExpression initializer : initializers) {
                if (!(initializer instanceof PsiLiteralExpression)) continue;
                PsiLiteralExpression literal = (PsiLiteralExpression)initializer;
                if (OctalAndDecimalIntegersMixedVisitor.isDecimalLiteral(literal)) {
                    hasDecimalLiteral = true;
                }
                if (!OctalAndDecimalIntegersMixedVisitor.isOctalLiteral(literal)) continue;
                hasOctalLiteral = true;
            }
            if (hasOctalLiteral && hasDecimalLiteral) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private static boolean isDecimalLiteral(PsiLiteralExpression literal) {
            PsiType type = literal.getType();
            if (!PsiType.INT.equals((Object)type) && !PsiType.LONG.equals((Object)type)) {
                return false;
            }
            String text = literal.getText();
            if ("0".equals(text)) {
                return false;
            }
            return text.charAt(0) != '0';
        }

        private static boolean isOctalLiteral(PsiLiteralExpression literal) {
            PsiType type = literal.getType();
            if (!PsiType.INT.equals((Object)type) && !PsiType.LONG.equals((Object)type)) {
                return false;
            }
            String text = literal.getText();
            if ("0".equals(text) || "0L".equals(text)) {
                return false;
            }
            return text.charAt(0) == '0' && !text.startsWith("0x") && !text.startsWith("0X");
        }
    }
}

