/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class OverloadedVarargsMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("overloaded.vararg.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod element = (PsiMethod)infos[0];
        if (element.isConstructor()) {
            return InspectionGadgetsBundle.message("overloaded.vararg.constructor.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("overloaded.vararg.method.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedVarargMethodVisitor();
    }

    private static class OverloadedVarargMethodVisitor
    extends BaseInspectionVisitor {
        private OverloadedVarargMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] sameNameMethods;
            if (!method.isVarArgs()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String methodName = method.getName();
            for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, true)) {
                if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)sameNameMethod, (PsiMethod)method)) continue;
                this.registerMethodError(method, method);
                return;
            }
        }
    }
}

