/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.NonExceptionNameEndsWithExceptionInspectionBase;
import org.jetbrains.annotations.NotNull;

public class NonExceptionNameEndsWithExceptionInspection
extends NonExceptionNameEndsWithExceptionInspectionBase {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String name = (String)infos[0];
        Boolean onTheFly = (Boolean)infos[1];
        if (onTheFly.booleanValue()) {
            return new InspectionGadgetsFix[]{new RenameFix(), new ExtendExceptionFix(name)};
        }
        return new InspectionGadgetsFix[]{new ExtendExceptionFix(name)};
    }

    private static class ExtendExceptionFix
    extends InspectionGadgetsFix {
        private final String name;

        ExtendExceptionFix(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.quickfix", this.name);
        }

        @NotNull
        public String getFamilyName() {
            return "Make class extend 'Exception'";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = facade.getElementFactory();
            GlobalSearchScope scope = aClass.getResolveScope();
            PsiJavaCodeReferenceElement reference = factory.createReferenceElementByFQClassName("java.lang.Exception", scope);
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                referenceElement.delete();
            }
            extendsList.add((PsiElement)reference);
        }
    }
}

