/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MethodNameSameAsParentNameInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.name.same.as.parent.name.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.name.same.as.parent.name.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodNameSameAsParentClassNameVisitor();
    }

    private static class MethodNameSameAsParentClassNameVisitor
    extends BaseInspectionVisitor {
        private MethodNameSameAsParentClassNameVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiClass parent = containingClass.getSuperClass();
            if (parent == null) {
                return;
            }
            String parentName = parent.getName();
            if (parentName == null) {
                return;
            }
            String methodName = method.getName();
            if (!methodName.equals(parentName)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

