/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.MethodNameSameAsClassNameInspectionBase;
import org.jetbrains.annotations.NotNull;

public class MethodNameSameAsClassNameInspection
extends MethodNameSameAsClassNameInspectionBase {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Boolean onTheFly = (Boolean)infos[0];
        if (onTheFly.booleanValue()) {
            return new InspectionGadgetsFix[]{new RenameFix(), new MethodNameSameAsClassNameFix()};
        }
        return new InspectionGadgetsFix[]{new MethodNameSameAsClassNameFix()};
    }

    private static class MethodNameSameAsClassNameFix
    extends InspectionGadgetsFix {
        private MethodNameSameAsClassNameFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("make.method.ctr.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)parent;
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement == null) {
                return;
            }
            returnTypeElement.delete();
        }
    }
}

