/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.modularization;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleWithTooFewClassesInspection
extends BaseGlobalInspection {
    public int limit = 10;

    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("module.with.too.few.classes.display.name", new Object[0]);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefModule)) {
            return null;
        }
        RefModule refModule = (RefModule)refEntity;
        List children2 = refModule.getChildren();
        if (children2 == null) {
            return null;
        }
        int numClasses = 0;
        for (RefEntity child : children2) {
            if (!(child instanceof RefClass)) continue;
            ++numClasses;
        }
        if (numClasses >= this.limit || numClasses == 0) {
            return null;
        }
        Project project2 = globalInspectionContext.getProject();
        Module[] modules = ModuleManager.getInstance((Project)project2).getModules();
        if (modules.length == 1) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("module.with.too.few.classes.problem.descriptor", refModule.getName(), numClasses, this.limit);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("module.with.too.few.classes.min.option", new Object[0]), (InspectionProfileEntry)this, "limit");
    }
}

