/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryBoxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyBoxed = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.boxing.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.boxing.superfluous.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportSuperfluouslyBoxed");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.boxing.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryBoxingFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBoxingVisitor();
    }

    private class UnnecessaryBoxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBoxingVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiType expectedType;
            super.visitNewExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiType constructorType = expression.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)constructorType);
            if (unboxedType == null) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            PsiType argumentType = boxedExpression.getType();
            if (!(argumentType instanceof PsiPrimitiveType) || !this.canRemainUnboxed((PsiExpression)expression, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            if (!(boxedExpression.getType() instanceof PsiPrimitiveType)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            String canonicalText = referenceExpression.getCanonicalText();
            if (PsiTypesUtil.unboxIfPossible((String)canonicalText) == canonicalText || !this.canRemainUnboxed((PsiExpression)expression, boxedExpression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private boolean canRemainUnboxed(PsiExpression expression, PsiExpression boxedExpression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                expression = (PsiExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiReferenceExpression) {
                return false;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                return !TypeUtils.isTypeParameter(castExpression.getType());
            }
            if (parent instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                PsiExpression thenExpression = conditionalExpression.getThenExpression();
                PsiExpression elseExpression = conditionalExpression.getElseExpression();
                if (elseExpression == null || thenExpression == null) {
                    return false;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)thenExpression, (PsiElement)expression, (boolean)false)) {
                    PsiType type = elseExpression.getType();
                    return type instanceof PsiPrimitiveType;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)elseExpression, (PsiElement)expression, (boolean)false)) {
                    PsiType type = thenExpression.getType();
                    return type instanceof PsiPrimitiveType;
                }
                return true;
            }
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                return !this.isPossibleObjectComparison(expression, polyadicExpression);
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return true;
            }
            PsiCallExpression containingCallExpression = (PsiCallExpression)grandParent;
            return this.isSameMethodCalledWithoutBoxing(containingCallExpression, expression, boxedExpression);
        }

        private boolean isPossibleObjectComparison(PsiExpression expression, PsiPolyadicExpression polyadicExpression) {
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                return false;
            }
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (operand == expression || operand.getType() instanceof PsiPrimitiveType) continue;
                return true;
            }
            return false;
        }

        private boolean canBinaryExpressionBeUnboxed(PsiExpression lhs, PsiExpression rhs) {
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return false;
            }
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return false;
            }
            if (!(lhsType instanceof PsiPrimitiveType) && !ExpressionUtils.isAnnotatedNotNull(lhs)) {
                return false;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)rhsType);
            return unboxedType != null && unboxedType.isAssignableFrom(lhsType);
        }

        private boolean isSameMethodCalledWithoutBoxing(@NotNull PsiCallExpression methodCallExpression, @NotNull PsiExpression boxingExpression, @NotNull PsiExpression boxedExpression) {
            PsiMethod originalMethod = methodCallExpression.resolveMethod();
            if (originalMethod == null) {
                return false;
            }
            PsiMethod otherMethod = MethodCallUtils.findMethodWithReplacedArgument((PsiCall)methodCallExpression, boxingExpression, boxedExpression);
            return originalMethod == otherMethod;
        }
    }

    private static class UnnecessaryBoxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryBoxingFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("unnecessary.boxing.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(@NotNull Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiCallExpression expression = (PsiCallExpression)descriptor.getPsiElement();
            PsiType boxedType = expression.getType();
            if (boxedType == null) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression unboxedExpression = arguments[0];
            String replacementText = UnnecessaryBoxingFix.getUnboxedExpressionText(unboxedExpression, boxedType);
            if (replacementText == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, replacementText);
        }

        @Nullable
        private static String getUnboxedExpressionText(@NotNull PsiExpression unboxedExpression, @NotNull PsiType boxedType) {
            PsiType expressionType = unboxedExpression.getType();
            if (expressionType == null) {
                return null;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)boxedType);
            if (unboxedType == null) {
                return null;
            }
            String text = unboxedExpression.getText();
            if (expressionType.equals(unboxedType)) {
                return text;
            }
            if (unboxedExpression instanceof PsiLiteralExpression) {
                if (unboxedType.equals(PsiType.LONG) && expressionType.equals(PsiType.INT)) {
                    return text + 'L';
                }
                if (unboxedType.equals(PsiType.FLOAT) && (expressionType.equals(PsiType.INT) || expressionType.equals(PsiType.DOUBLE) && !StringUtil.endsWithIgnoreCase((String)text, (String)"d"))) {
                    return text + 'f';
                }
                if (unboxedType.equals(PsiType.DOUBLE) && expressionType.equals(PsiType.INT)) {
                    return text + 'd';
                }
            }
            if (ParenthesesUtils.getPrecedence(unboxedExpression) > 4) {
                return '(' + unboxedType.getCanonicalText() + ")(" + text + ')';
            }
            return '(' + unboxedType.getCanonicalText() + ')' + text;
        }
    }
}

