/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EnumerationCanBeIterationInspectionBase
extends BaseInspection {
    static final int KEEP_NOTHING = 0;
    static final int KEEP_INITIALIZATION = 1;
    static final int KEEP_DECLARATION = 2;
    @NonNls
    static final String ITERATOR_TEXT = "iterator()";
    @NonNls
    static final String KEY_SET_ITERATOR_TEXT = "keySet().iterator()";
    @NonNls
    static final String VALUES_ITERATOR_TEXT = "values().iterator()";

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("enumeration.can.be.iteration.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("enumeration.can.be.iteration.problem.descriptor", infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EnumerationCanBeIterationVisitor();
    }

    private static class EnumerationCanBeIterationVisitor
    extends BaseInspectionVisitor {
        private EnumerationCanBeIterationVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiClass containingClass;
            PsiMethod method;
            PsiVariable variable;
            boolean isElements;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("elements".equals(methodName)) {
                isElements = true;
            } else if ("keys".equals(methodName)) {
                isElements = false;
            } else {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression, "java.util.Enumeration")) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiLocalVariable) {
                variable = (PsiVariable)parent;
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiVariable)) {
                    return;
                }
                variable = (PsiVariable)element;
            } else {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (containingMethod == null) {
                return;
            }
            if (!EnumerationCanBeIterationVisitor.isEnumerationMethodCalled(variable, (PsiElement)containingMethod)) {
                return;
            }
            if (isElements) {
                method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                containingClass = method.getContainingClass();
                if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Vector")) {
                    this.registerMethodCallError(expression, EnumerationCanBeIterationInspectionBase.ITERATOR_TEXT);
                } else if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Hashtable")) {
                    this.registerMethodCallError(expression, EnumerationCanBeIterationInspectionBase.VALUES_ITERATOR_TEXT);
                }
            } else {
                method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                containingClass = method.getContainingClass();
                if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Hashtable")) {
                    this.registerMethodCallError(expression, EnumerationCanBeIterationInspectionBase.KEY_SET_ITERATOR_TEXT);
                }
            }
        }

        private static boolean isEnumerationMethodCalled(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            EnumerationMethodCalledVisitor visitor = new EnumerationMethodCalledVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isEnumerationMethodCalled();
        }

        private static class EnumerationMethodCalledVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiVariable variable;
            private boolean enumerationMethodCalled;

            private EnumerationMethodCalledVisitor(@NotNull PsiVariable variable) {
                this.variable = variable;
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                if (this.enumerationMethodCalled) {
                    return;
                }
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"hasMoreElements".equals(methodName) && !"nextElement".equals(methodName)) {
                    return;
                }
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)element;
                this.enumerationMethodCalled = this.variable.equals(variable);
            }

            private boolean isEnumerationMethodCalled() {
                return this.enumerationMethodCalled;
            }
        }
    }
}

