/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionsFieldAccessReplaceableByMethodCallInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("collections.field.access.replaceable.by.method.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("collections.field.access.replaceable.by.method.call.problem.descriptor", infos[1]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression expression = (PsiReferenceExpression)infos[0];
        return new CollectionsFieldAccessReplaceableByMethodCallFix(expression.getReferenceName());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionsFieldAccessReplaceableByMethodCallVisitor();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    private static class CollectionsFieldAccessReplaceableByMethodCallVisitor
    extends BaseInspectionVisitor {
        private CollectionsFieldAccessReplaceableByMethodCallVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            String replacement;
            super.visitReferenceExpression(expression);
            String name = expression.getReferenceName();
            if ("EMPTY_LIST".equals(name)) {
                replacement = "emptyList()";
            } else if ("EMPTY_MAP".equals(name)) {
                replacement = "emptyMap()";
            } else if ("EMPTY_SET".equals(name)) {
                replacement = "emptySet()";
            } else {
                return;
            }
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.util.Collections".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, replacement);
        }
    }

    private static class CollectionsFieldAccessReplaceableByMethodCallFix
    extends InspectionGadgetsFix {
        private final String replacementText;

        private CollectionsFieldAccessReplaceableByMethodCallFix(String referenceName) {
            this.replacementText = CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallText(referenceName);
        }

        @NotNull
        public String getFamilyName() {
            return "Replace Collections.EMPTY_* with call";
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("collections.field.access.replaceable.by.method.call.quickfix", this.replacementText);
        }

        @NonNls
        private static String getCollectionsMethodCallText(PsiReferenceExpression referenceExpression) {
            String referenceName = referenceExpression.getReferenceName();
            PsiElement parent = referenceExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return CollectionsFieldAccessReplaceableByMethodCallFix.getUntypedCollectionsMethodCallText(referenceName);
            }
            PsiType type = ExpectedTypeUtils.findExpectedType((PsiExpression)referenceExpression, false);
            if (!(type instanceof PsiClassType)) {
                return CollectionsFieldAccessReplaceableByMethodCallFix.getUntypedCollectionsMethodCallText(referenceName);
            }
            PsiClassType classType = (PsiClassType)type;
            PsiType[] parameterTypes = classType.getParameters();
            boolean useTypeParameter = false;
            String[] canonicalTexts = new String[parameterTypes.length];
            for (PsiType parameterType : parameterTypes) {
                if (parameterType instanceof PsiWildcardType) {
                    PsiWildcardType wildcardType = (PsiWildcardType)parameterType;
                    PsiType bound = wildcardType.getBound();
                    if (bound != null) {
                        if (!bound.equalsToText("java.lang.Object")) {
                            useTypeParameter = true;
                        }
                        canonicalTexts[i] = bound.getCanonicalText();
                        continue;
                    }
                    canonicalTexts[i] = "java.lang.Object";
                    continue;
                }
                if (!parameterType.equalsToText("java.lang.Object")) {
                    useTypeParameter = true;
                }
                canonicalTexts[i] = parameterType.getCanonicalText();
            }
            if (useTypeParameter) {
                return "Collections.<" + StringUtil.join((String[])canonicalTexts, (String)",") + '>' + CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallText(referenceName);
            }
            return CollectionsFieldAccessReplaceableByMethodCallFix.getUntypedCollectionsMethodCallText(referenceName);
        }

        @NonNls
        private static String getUntypedCollectionsMethodCallText(String referenceName) {
            return "Collections." + CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallText(referenceName);
        }

        @NonNls
        private static String getCollectionsMethodCallText(@NonNls String referenceName) {
            if ("EMPTY_LIST".equals(referenceName)) {
                return "emptyList()";
            }
            if ("EMPTY_MAP".equals(referenceName)) {
                return "emptyMap()";
            }
            if ("EMPTY_SET".equals(referenceName)) {
                return "emptySet()";
            }
            throw new AssertionError((Object)("unknown collections field name: " + referenceName));
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            String newMethodCallText = CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallText(referenceExpression);
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, "java.util." + newMethodCallText);
        }
    }
}

