/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.NegationCountVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ThreeNegationsPerMethodInspection
extends BaseInspection {
    public boolean m_ignoreInEquals = true;
    public boolean ignoreInAssert = false;

    @NotNull
    public String getID() {
        return "MethodWithMoreThanThreeNegations";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("three.negations.per.method.display.name", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("three.negations.per.method.ignore.option", new Object[0]), "m_ignoreInEquals");
        panel.addCheckbox(InspectionGadgetsBundle.message("three.negations.per.method.ignore.assert.option", new Object[0]), "ignoreInAssert");
        return panel;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer negationCount = (Integer)infos[0];
        return InspectionGadgetsBundle.message("three.negations.per.method.problem.descriptor", negationCount);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreeNegationsPerMethodVisitor();
    }

    private class ThreeNegationsPerMethodVisitor
    extends BaseInspectionVisitor {
        private ThreeNegationsPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.getNameIdentifier() == null) {
                return;
            }
            NegationCountVisitor visitor = new NegationCountVisitor(ThreeNegationsPerMethodInspection.this.ignoreInAssert);
            method.accept((PsiElementVisitor)visitor);
            int negationCount = visitor.getCount();
            if (negationCount <= 3) {
                return;
            }
            if (ThreeNegationsPerMethodInspection.this.m_ignoreInEquals && MethodUtils.isEquals(method)) {
                return;
            }
            this.registerMethodError(method, negationCount);
        }
    }
}

