/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public class ParametersPerConstructorInspectionBase
extends MethodMetricInspection {
    public Scope ignoreScope = Scope.NONE;

    @NotNull
    public String getID() {
        return "ConstructorWithTooManyParameters";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("parameters.per.constructor.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer parameterCount = (Integer)infos[0];
        return InspectionGadgetsBundle.message("parameters.per.constructor.problem.descriptor", parameterCount);
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("parameter.limit.option", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParametersPerConstructorVisitor();
    }

    private class ParametersPerConstructorVisitor
    extends BaseInspectionVisitor {
        private ParametersPerConstructorVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameterList parameterList;
            int parametersCount;
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.isConstructor()) {
                return;
            }
            if (ParametersPerConstructorInspectionBase.this.ignoreScope != Scope.NONE) {
                switch (ParametersPerConstructorInspectionBase.this.ignoreScope.ordinal()) {
                    case 3: {
                        if (method.hasModifierProperty("protected")) {
                            return;
                        }
                    }
                    case 2: {
                        if (method.hasModifierProperty("packageLocal")) {
                            return;
                        }
                    }
                    case 1: {
                        if (!method.hasModifierProperty("private")) break;
                        return;
                    }
                }
            }
            if ((parametersCount = (parameterList = method.getParameterList()).getParametersCount()) <= ParametersPerConstructorInspectionBase.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, parametersCount);
        }
    }

    protected static enum Scope {
        NONE{

            @Override
            String getText() {
                return InspectionGadgetsBundle.message("none", new Object[0]);
            }
        }
        ,
        PRIVATE{

            @Override
            String getText() {
                return InspectionGadgetsBundle.message("private", new Object[0]);
            }
        }
        ,
        PACKAGE_LOCAL{

            @Override
            String getText() {
                return InspectionGadgetsBundle.message("package.local.private", new Object[0]);
            }
        }
        ,
        PROTECTED{

            @Override
            String getText() {
                return InspectionGadgetsBundle.message("protected.package.local.private", new Object[0]);
            }
        };


        abstract String getText();
    }
}

