/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ZeroLengthArrayInitializationInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ZeroLengthArrayAllocation";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("array.allocation.zero.length.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("array.allocation.zero.length.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ZeroLengthArrayInitializationVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static class ZeroLengthArrayInitializationVisitor
    extends BaseInspectionVisitor {
        private ZeroLengthArrayInitializationVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (!ExpressionUtils.isZeroLengthArrayConstruction((PsiExpression)expression)) {
                return;
            }
            if (ExpressionUtils.isDeclaredConstant((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            super.visitArrayInitializerExpression(expression);
            PsiExpression[] initializers = expression.getInitializers();
            if (initializers.length > 0) {
                return;
            }
            if (expression.getParent() instanceof PsiNewExpression) {
                return;
            }
            if (ExpressionUtils.isDeclaredConstant((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }
}

