/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class StringBufferFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("stringbuffer.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String typeName = type.getPresentableText();
        return InspectionGadgetsBundle.message("stringbuffer.field.problem.descriptor", typeName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferFieldVisitor();
    }

    private static class StringBufferFieldVisitor
    extends BaseInspectionVisitor {
        private StringBufferFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            PsiType type = field.getType();
            if (!type.equalsToText("java.lang.StringBuffer") && !type.equalsToText("java.lang.StringBuilder")) {
                return;
            }
            this.registerFieldError(field, type);
        }
    }
}

