/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class InnerClassReferenceVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiClass innerClass;
    private boolean referencesStaticallyAccessible = true;

    public InnerClassReferenceVisitor(@NotNull PsiClass innerClass) {
        this.innerClass = innerClass;
    }

    public boolean canInnerClassBeStatic() {
        PsiClass superClass = this.innerClass.getSuperClass();
        if (superClass != null && !this.isClassStaticallyAccessible(superClass)) {
            return false;
        }
        return this.referencesStaticallyAccessible;
    }

    private boolean isClassStaticallyAccessible(@NotNull PsiClass aClass) {
        if (PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)aClass, (boolean)false) || aClass.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass = aClass.getContainingClass();
        return containingClass == null || InheritanceUtil.isInheritorOrSelf((PsiClass)this.innerClass, (PsiClass)containingClass, (boolean)true);
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitThisExpression(expression);
        if (this.hasContainingClassQualifier((PsiQualifiedExpression)expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitSuperExpression(expression);
        if (this.hasContainingClassQualifier((PsiQualifiedExpression)expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    private boolean hasContainingClassQualifier(PsiQualifiedExpression expression) {
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        return qualifier != null && !this.innerClass.equals(qualifier.resolve());
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitReferenceExpression(expression);
        PsiExpression qualifierExpression = ParenthesesUtils.stripParentheses(expression.getQualifierExpression());
        if (qualifierExpression != null) {
            return;
        }
        PsiElement target = expression.resolve();
        if (target instanceof PsiLocalVariable || target instanceof PsiParameter) {
            return;
        }
        if (target instanceof PsiMethod || target instanceof PsiField) {
            PsiMember member = (PsiMember)target;
            if (member.hasModifierProperty("static") || PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)member, (boolean)true)) {
                return;
            }
            if (!member.hasModifierProperty("private")) {
                PsiClass containingClass = member.getContainingClass();
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)this.innerClass, (PsiClass)containingClass, (boolean)true)) {
                    return;
                }
                PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
                while (parentClass != null && PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)parentClass, (boolean)true)) {
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true)) {
                        return;
                    }
                    parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true);
                }
            }
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitNewExpression(PsiNewExpression expression) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitNewExpression(expression);
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        if (classReference == null) {
            return;
        }
        PsiElement target = classReference.resolve();
        if (!(target instanceof PsiClass)) {
            return;
        }
        if (!this.isClassStaticallyAccessible((PsiClass)target)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitTypeElement(PsiTypeElement typeElement) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitTypeElement(typeElement);
        PsiType type = typeElement.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass instanceof PsiTypeParameter && !PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)aClass, (boolean)true)) {
            this.referencesStaticallyAccessible = false;
        }
    }
}

