/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class ThreadDumpStackInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToThreadDumpStack";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("dumpstack.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("dumpstack.call.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadDumpStackVisitor();
    }

    private static class ThreadDumpStackVisitor
    extends BaseInspectionVisitor {
        private ThreadDumpStackVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            String methodName = MethodCallUtils.getMethodName(expression);
            if (!"dumpStack".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiElement element = methodExpression.resolve();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)element;
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (!"java.lang.Thread".equals(qualifiedName)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

