/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObsoleteCollectionInspection
extends BaseInspection {
    public boolean ignoreRequiredObsoleteCollectionTypes = false;

    @NotNull
    public String getID() {
        return "UseOfObsoleteCollectionType";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("use.obsolete.collection.type.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("use.obsolete.collection.type.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("use.obsolete.collection.type.ignore.library.arguments.option", new Object[0]), (InspectionProfileEntry)this, "ignoreRequiredObsoleteCollectionTypes");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObsoleteCollectionVisitor();
    }

    private class ObsoleteCollectionVisitor
    extends BaseInspectionVisitor {
        private ObsoleteCollectionVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            super.visitVariable(variable);
            PsiType type = variable.getType();
            if (!this.isObsoleteCollectionType(type)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethodParameter(variable)) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (ObsoleteCollectionInspection.this.ignoreRequiredObsoleteCollectionTypes && this.isUsedAsParameterForLibraryMethod((PsiNamedElement)variable)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiType returnType = method.getReturnType();
            if (!this.isObsoleteCollectionType(returnType)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            if (ObsoleteCollectionInspection.this.ignoreRequiredObsoleteCollectionTypes && this.isUsedAsParameterForLibraryMethod((PsiNamedElement)method)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            super.visitNewExpression(newExpression);
            PsiType type = newExpression.getType();
            if (!this.isObsoleteCollectionType(type)) {
                return;
            }
            if (ObsoleteCollectionInspection.this.ignoreRequiredObsoleteCollectionTypes && this.isRequiredObsoleteCollectionElement((PsiElement)newExpression)) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }

        private boolean isObsoleteCollectionType(@Nullable PsiType type) {
            if (type == null) {
                return false;
            }
            PsiType deepComponentType = type.getDeepComponentType();
            if (!(deepComponentType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)deepComponentType;
            String className = classType.getClassName();
            if (!"Vector".equals(className) && !"Hashtable".equals(className)) {
                return false;
            }
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return false;
            }
            String name = aClass.getQualifiedName();
            return "java.util.Vector".equals(name) || "java.util.Hashtable".equals(name);
        }

        private boolean isUsedAsParameterForLibraryMethod(PsiNamedElement namedElement) {
            PsiFile containingFile = namedElement.getContainingFile();
            Query query = ReferencesSearch.search((PsiElement)namedElement, (SearchScope)GlobalSearchScope.fileScope((PsiFile)containingFile));
            for (PsiReference reference : query) {
                PsiElement element = reference.getElement();
                if (!this.isRequiredObsoleteCollectionElement(element)) continue;
                return true;
            }
            return false;
        }

        private boolean isRequiredObsoleteCollectionElement(PsiElement element) {
            PsiAssignmentExpression assignmentExpression;
            PsiExpression lhs;
            PsiType lhsType;
            PsiElement container;
            Object returnType;
            PsiVariable variable;
            PsiType variableType;
            PsiElement parent = element.getParent();
            if (parent instanceof PsiVariable ? this.isObsoleteCollectionType(variableType = (variable = (PsiVariable)parent).getType()) : (parent instanceof PsiReturnStatement ? this.isObsoleteCollectionType((PsiType)(returnType = (container = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class})) instanceof PsiMethod ? ((PsiMethod)container).getReturnType() : (container instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)container)) : null))) : parent instanceof PsiAssignmentExpression && this.isObsoleteCollectionType(lhsType = (lhs = (assignmentExpression = (PsiAssignmentExpression)parent).getLExpression()).getType()))) {
                return true;
            }
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList argumentList = (PsiExpressionList)parent;
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return false;
            }
            PsiCallExpression callExpression = (PsiCallExpression)grandParent;
            int index = this.getIndexOfArgument(argumentList, element);
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (index >= parameters.length) {
                PsiParameter lastParameter = parameters[parameters.length - 1];
                if (!lastParameter.isVarArgs()) {
                    return false;
                }
                PsiType type = lastParameter.getType();
                if (!(type instanceof PsiEllipsisType)) {
                    return false;
                }
                PsiEllipsisType ellipsisType = (PsiEllipsisType)type;
                PsiType componentType = ellipsisType.getComponentType();
                return this.isObsoleteCollectionType(componentType);
            }
            PsiParameter parameter = parameters[index];
            PsiType type = parameter.getType();
            return this.isObsoleteCollectionType(type);
        }

        private int getIndexOfArgument(PsiExpressionList argumentList, PsiElement argument) {
            PsiExpression[] expressions = argumentList.getExpressions();
            int index = -1;
            for (PsiExpression expression : expressions) {
                ++index;
                if (expression.equals(argument)) break;
            }
            return index;
        }
    }
}

