/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PlaceholderCountMatchesArgumentCountInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> loggingMethodNames = ContainerUtilRt.newHashSet((Object[])new String[]{"log", "trace", "debug", "info", "warn", "error", "fatal"});

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer argumentCount = (Integer)infos[0];
        Integer placeholderCount = (Integer)infos[1];
        if (argumentCount > placeholderCount) {
            return InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.more.problem.descriptor", argumentCount, placeholderCount);
        }
        return InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.fewer.problem.descriptor", argumentCount, placeholderCount);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PlaceholderCountMatchesArgumentCountVisitor();
    }

    private static class PlaceholderCountMatchesArgumentCountVisitor
    extends BaseInspectionVisitor {
        private PlaceholderCountMatchesArgumentCountVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            int argumentCount;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!loggingMethodNames.contains(name)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.slf4j.Logger") && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.apache.logging.log4j.Logger")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression logStringArgument = arguments[0];
            if (!ExpressionUtils.hasStringType(logStringArgument)) {
                if (arguments.length < 2) {
                    return;
                }
                logStringArgument = arguments[1];
                argumentCount = PlaceholderCountMatchesArgumentCountVisitor.countArguments(arguments, 2);
            } else {
                argumentCount = PlaceholderCountMatchesArgumentCountVisitor.countArguments(arguments, 1);
            }
            int placeholderCount = PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders(logStringArgument);
            if (placeholderCount < 0 || argumentCount < 0 || placeholderCount == argumentCount) {
                return;
            }
            if (placeholderCount > 1 && placeholderCount == argumentCount + 1 && PlaceholderCountMatchesArgumentCountVisitor.hasThrowableType(arguments[arguments.length - 1])) {
                return;
            }
            this.registerError((PsiElement)logStringArgument, argumentCount, placeholderCount);
        }

        private static boolean hasThrowableType(PsiExpression lastArgument) {
            PsiType type = lastArgument.getType();
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    if (InheritanceUtil.isInheritor((PsiType)disjunction, (String)"java.lang.Throwable")) continue;
                    return false;
                }
                return true;
            }
            return InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Throwable");
        }

        public static int countPlaceholders(PsiExpression expression) {
            Object value = ExpressionUtils.computeConstantExpression(expression);
            if (value == null) {
                StringBuilder builder = new StringBuilder();
                return PlaceholderCountMatchesArgumentCountVisitor.buildString(expression, builder) ? PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders(builder.toString()) : -1;
            }
            return value instanceof String ? PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders((String)value) : 0;
        }

        private static boolean buildString(PsiExpression expression, StringBuilder builder) {
            PsiType type = expression.getType();
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                return PlaceholderCountMatchesArgumentCountVisitor.buildString(parenthesizedExpression.getExpression(), builder);
            }
            if (expression instanceof PsiPolyadicExpression) {
                if (!TypeUtils.isJavaLangString(type) && !PsiType.CHAR.equals((Object)type)) {
                    return true;
                }
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (PlaceholderCountMatchesArgumentCountVisitor.buildString(operand, builder)) continue;
                    return false;
                }
                return true;
            }
            if (expression instanceof PsiLiteralExpression) {
                if (TypeUtils.isJavaLangString(type) || PsiType.CHAR.equals((Object)type)) {
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
                    builder.append(literalExpression.getValue());
                }
                return true;
            }
            if (!TypeUtils.isJavaLangString(type)) {
                return true;
            }
            Object value = ExpressionUtils.computeConstantExpression(expression);
            if (value == null) {
                return false;
            }
            builder.append(value);
            return true;
        }

        private static int countPlaceholders(String string) {
            int count = 0;
            int index = string.indexOf("{}");
            while (index >= 0) {
                if (index == 0 || string.charAt(index - 1) != '\\') {
                    ++count;
                }
                index = string.indexOf("{}", index + 1);
            }
            return count;
        }

        private static int countArguments(PsiExpression[] arguments, int countFrom) {
            PsiExpression argument;
            PsiType argumentType;
            if (arguments.length <= countFrom) {
                return 0;
            }
            int count = arguments.length - countFrom;
            if (count == 1 && (argumentType = (argument = arguments[countFrom]).getType()) instanceof PsiArrayType) {
                PsiNewExpression newExpression;
                PsiArrayInitializerExpression arrayInitializerExpression;
                if (argumentType.equalsToText("java.lang.Object[]") && argument instanceof PsiNewExpression && (arrayInitializerExpression = (newExpression = (PsiNewExpression)argument).getArrayInitializer()) != null) {
                    return arrayInitializerExpression.getInitializers().length;
                }
                return -1;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            return PlaceholderCountMatchesArgumentCountVisitor.hasThrowableType(lastArgument) ? count - 1 : count;
        }
    }
}

