/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogStatementGuardedByLogConditionInspectionBase
extends BaseInspection {
    final List<String> logMethodNameList = new ArrayList<String>();
    final List<String> logConditionMethodNameList = new ArrayList<String>();
    public String loggerClassName = "java.util.logging.Logger";
    @NonNls
    public String loggerMethodAndconditionMethodNames = "fine,isLoggable(java.util.logging.Level.FINE),finer,isLoggable(java.util.logging.Level.FINER),finest,isLoggable(java.util.logging.Level.FINEST)";
    public boolean flagAllUnguarded = false;

    public LogStatementGuardedByLogConditionInspectionBase() {
        LogStatementGuardedByLogConditionInspectionBase.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LogStatementGuardedByLogConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LogStatementGuardedByLogConditionVisitor();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        LogStatementGuardedByLogConditionInspectionBase.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.loggerMethodAndconditionMethodNames = LogStatementGuardedByLogConditionInspectionBase.formatString(this.logMethodNameList, this.logConditionMethodNameList);
        super.writeSettings(element);
    }

    private class LogStatementGuardedByLogConditionVisitor
    extends BaseInspectionVisitor {
        private LogStatementGuardedByLogConditionVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!LogStatementGuardedByLogConditionInspectionBase.this.logMethodNameList.contains(referenceName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspectionBase.this.loggerClassName)) {
                return;
            }
            if (this.isSurroundedByLogGuard((PsiElement)expression, referenceName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            if (!LogStatementGuardedByLogConditionInspectionBase.this.flagAllUnguarded) {
                boolean constant = true;
                for (PsiExpression argument : arguments) {
                    if (PsiUtil.isConstantExpression((PsiExpression)argument)) continue;
                    constant = false;
                    break;
                }
                if (constant) {
                    return;
                }
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private boolean isSurroundedByLogGuard(PsiElement element, String logMethodName) {
            PsiIfStatement ifStatement;
            while ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) != null) {
                PsiExpression condition = ifStatement.getCondition();
                if (this.isLogGuardCheck(condition, logMethodName)) {
                    return true;
                }
                element = ifStatement;
            }
            return false;
        }

        private boolean isLogGuardCheck(@Nullable PsiExpression expression, String logMethodName) {
            if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspectionBase.this.loggerClassName)) {
                    return false;
                }
                String referenceName = methodExpression.getReferenceName();
                if (referenceName == null) {
                    return false;
                }
                int index = LogStatementGuardedByLogConditionInspectionBase.this.logMethodNameList.indexOf(logMethodName);
                String conditionName = LogStatementGuardedByLogConditionInspectionBase.this.logConditionMethodNameList.get(index);
                return conditionName.startsWith(referenceName);
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiExpression[] operands;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    if (!this.isLogGuardCheck(operand, logMethodName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class LogStatementGuardedByLogConditionFix
    extends InspectionGadgetsFix {
        private LogStatementGuardedByLogConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element.getParent().getParent();
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiStatement.class);
            if (statement2 == null) {
                return;
            }
            ArrayList<PsiStatement> logStatements = new ArrayList<PsiStatement>();
            logStatements.add(statement2);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement2, PsiStatement.class);
            while (previousStatement != null && this.isSameLogMethodCall(previousStatement, referenceName)) {
                logStatements.add(0, previousStatement);
                previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)previousStatement, PsiStatement.class);
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
            while (nextStatement != null && this.isSameLogMethodCall(nextStatement, referenceName)) {
                logStatements.add(nextStatement);
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            int index = LogStatementGuardedByLogConditionInspectionBase.this.logMethodNameList.indexOf(referenceName);
            String conditionMethodText = LogStatementGuardedByLogConditionInspectionBase.this.logConditionMethodNameList.get(index);
            String ifStatementText = "if (" + qualifier.getText() + '.' + conditionMethodText + ") {}";
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(ifStatementText, (PsiElement)statement2);
            PsiBlockStatement blockStatement = (PsiBlockStatement)ifStatement.getThenBranch();
            if (blockStatement == null) {
                return;
            }
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            for (PsiStatement logStatement : logStatements) {
                codeBlock.add((PsiElement)logStatement);
            }
            PsiStatement firstStatement = (PsiStatement)logStatements.get(0);
            PsiElement parent = firstStatement.getParent();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getElseBranch() != null) {
                PsiBlockStatement newBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)statement2);
                newBlockStatement.getCodeBlock().add((PsiElement)ifStatement);
                PsiElement result = firstStatement.replace((PsiElement)newBlockStatement);
                codeStyleManager.shortenClassReferences(result);
                return;
            }
            PsiElement result = parent.addBefore((PsiElement)ifStatement, (PsiElement)firstStatement);
            codeStyleManager.shortenClassReferences(result);
            for (PsiStatement logStatement : logStatements) {
                logStatement.delete();
            }
        }

        private boolean isSameLogMethodCall(PsiStatement statement2, @NotNull String methodName) {
            if (statement2 == null) {
                return false;
            }
            if (!(statement2 instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!methodName.equals(referenceName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return qualifier != null && TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspectionBase.this.loggerClassName);
        }
    }
}

