/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassWithoutLoggerInspectionBase
extends BaseInspection {
    protected final List<String> loggerNames = new ArrayList<String>();
    @NonNls
    public String loggerNamesString = "java.util.logging.Logger,org.slf4j.Logger,org.apache.commons.logging.Log,org.apache.log4j.Logger";
    public boolean ignoreSuperLoggers = false;

    public ClassWithoutLoggerInspectionBase() {
        ClassWithoutLoggerInspectionBase.parseString(this.loggerNamesString, this.loggerNames);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("no.logger.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("no.logger.problem.descriptor", new Object[0]);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        ClassWithoutLoggerInspectionBase.parseString(this.loggerNamesString, this.loggerNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.loggerNamesString = ClassWithoutLoggerInspectionBase.formatString(this.loggerNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutLoggerVisitor();
    }

    private class ClassWithoutLoggerVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutLoggerVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            PsiField[] fields = ClassWithoutLoggerInspectionBase.this.ignoreSuperLoggers ? aClass.getAllFields() : aClass.getFields();
            for (PsiField field : fields) {
                if (!this.isLogger((PsiVariable)field) || !PsiUtil.isAccessible((PsiMember)field, (PsiElement)aClass, (PsiClass)aClass)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean isLogger(PsiVariable variable) {
            PsiType type = variable.getType();
            String text = type.getCanonicalText();
            return ClassWithoutLoggerInspectionBase.this.loggerNames.contains(text);
        }
    }
}

