/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class TeardownIsPublicVoidNoArgInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "TearDownWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("teardown.is.public.void.no.arg.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("teardown.is.public.void.no.arg.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TeardownIsPublicVoidNoArgVisitor();
    }

    private static class TeardownIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private TeardownIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String methodName = method.getName();
            if (!"tearDown".equals(methodName)) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)targetClass, (String)"junit.framework.TestCase")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0 || !returnType.equals(PsiType.VOID) || !method.hasModifierProperty("public") && !method.hasModifierProperty("protected")) {
                this.registerMethodError(method, new Object[0]);
            }
        }
    }
}

